<?php
session_start();
unset($_SESSION['consulta']);

if ($_SESSION['username'] && $_SESSION['user']) {
?>
<!DOCTYPE html>
<html lang="es">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0"/>
  <title>Médica Nuclear - Diagnóstico con sentido humano</title>

  <!-- CSS  -->
  
    
<link href="iconfont/material-icons.css" rel="stylesheet">


<link rel="stylesheet" type="text/css" href="librerias/select2/css/select2.css">
<link rel="stylesheet" type="text/css" href="librerias/datatable/bootstrap.min.css"> <!-- algo causa error -->

<link href="../vendor/materialize/dist/css/materialize.min.css" type="text/css" rel="stylesheet" media="screen,projection"/>
<link rel="stylesheet" type="text/css" href="librerias/alertifyjs/css/alertify.css">
<link rel="stylesheet" type="text/css" href="librerias/alertifyjs/css/themes/default.css">
<link href="css/style.css" type="text/css" rel="stylesheet" media="screen,projection"/>
<link rel="stylesheet" type="text/css" href="librerias/bootstrap/css/bootstrap.css">
<link rel="stylesheet" type="text/css" href="librerias/datatable/dataTables.bootstrap.min.css">
<script src="librerias/jquery-3.2.1.min.js"></script>
<script src="js/funciones.js"></script>
<script src="librerias/bootstrap/js/bootstrap.js"></script>


<script src="../js/ajax.js"></script>
<script src="../js/request.js"></script>
<script src="../vendor/jquery/dist/jquery.min.js"></script>
<script src="../vendor/materialize/dist/js/materialize.min.js"></script>
<script src="librerias/datatable/jquery.dataTables.min.js"></script>
<script src="librerias/datatable/dataTables.bootstrap.min.js"></script>
<script src="librerias/alertifyjs/alertify.js"></script>
<script src="librerias/select2/js/select2.js"></script>
  
  
</head>
<body>
  <ul id="slide-out" class="side-nav fixed grey darken-4 white-text">
    <li class="logo">
      <a href="inicio" class="brand-logo">
        <img src="../img/Inicio/logomedicanuclear.png" alt="" width="200" heigth="350">
      </a>
    </li>
    <li><i class="material-icons left">person</i> <?php echo $_SESSION['username']; ?> </li>
    <li><a href="index.php" class="waves-effect waves-light"><h6>Inicio<i class="material-icons small right">home</i></h6></a></li>
    <li><a href="pacientes.php" class="waves-effect waves-light"><h6>Pacientes<i class="material-icons small right">people</i></h6></a></li>
    <li><a href="doctores.php" class="waves-effect waves-light"><h6>Doctores<i class="material-icons small right">person</i></h6></a></li>
    <li><a href="estudios.php" class="waves-effect waves-light"><h6>Estudios<i class="material-icons small right">work</i></h6></a></li>
    <li><a class="waves-effect waves-light active"><h6>Resultados<i class="material-icons small right">assignment</i></h6></a></li>
    <li><a href="reportes.php" class="waves-effect waves-light"><h6>Reportes<i class="material-icons small right">report</i></h6></a></li>
    
    <li><a href="#!" class="center-align waves-effect waves-light light-blue darken-4" id="cerrar-sesion-boton"><h6>Salir <i class="material-icons small valign-m">power_settings_new</i></h6></a></li>
  </ul>
  <header>
    <nav class="light-blue darken-2 expanded">
      <div class="nav-wrapper">
        <a href="#" data-activates="slide-out" class="button-collapse"><i class="material-icons">menu</i></a>
        <a href="#" class="brand-logo">Médica Nuclear</a>
        
      </div>
    </nav>
  </header>
<main>
    <div class="section">
      <div class="row">
        <div class="col s12">
          <div class="card-panel teal white-text">
            <span class="flow-text">Asignación de resultados</span>            
            <form id="nuevo-registro">
              <div class="row">
                <div class="col s12 m4 input-field">
                  <input type="text" id="nuevo_resultado_paciente" class="validate" required>
                  <label class="white-text" for="nuevo_resultado_paciente">Expediente del paciente</label>
                </div>
                <div class="col s12 m4 input-field">
                  <input type="text" id="nuevo_resultado_doctor" class="validate" required>
                  <label class="white-text" for="nuevo_resultado_doctor">Clave del doctor</label>
                </div>
                <div class="col s12 m4 input-field">
                  <input type="text" id="nuevo_resultado_estudio" class="validate" required>
                  <label class="white-text" for="nuevo_resultado_estudio">Clave del estudio</label>
                </div>
                <input type="hidden" id="nuevo_resultado_fecha">
              </div>
              <div class="row">
                <div class="col s12 m3 push-m9 right-align">
                  <button class="s12 btn waves-effect waves-light blue" data-form="nuevo-registro" id="boton-registro-nuevo">Registrar <i class="material-icons right">add</i></button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col s12">
          <div class="card-panel indigo white-text">
            <span class="flow-text">Resultados Pendientes</span>
            <div class="row">
              <form action="">
                <div class="input-field col s12">
                  <input type="text" name="inicio-busca-paciente" id="inicio-busca-paciente">
                  <label class="white-text" for="inicio-busca-paciente">Filtrar por paciente</label>
                </div>
              </form>
            </div>
            <div class="indigo darken-3 grey-text">
              <ul class="lista discreto" id="lista-resultados-pendientes">
              </ul>            
            </div>
          </div>
        </div>
      </div>  
    </div>
    <div class="row">
        <div class="section col-sm-12">
          <div class="card-panel blue white-text">
            <span class="flow-text">Borrar Resultados</span>
               
                       <div id="buscador"></div>

                       <div id="tabla">

                       </div>
            
    


    <!-- Modal Para Edicion de Registros -->


<!-- Modal -->
    <div class="modal fade" id="modalEdicion" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 style="color:#000" class="modal-title" id="myModalLabel">Actualiza tu Registro</h4>
          </div>
          <div class="modal-body">
              <input type="text" hidden="" id="idestudio" name="">
              <label>Nombre</label>
              <input type="text" name="" id="nombre_update" class="form-control input-sm" >
              <label>Apellido Paterno</label>
              <input type="text" name="" id="apellidoP_update" class="form-control input-sm" >
              <label>Fecha</label>
              <input type="date" name="" id="fecha_update" class="form-control input-sm">
              <label>Estudio</label>
              <input type="text" name="" id="estudio_update" class="form-control input-sm" disabled="">
              <label>Imagen</label>
              <input type="file" name="" id="img_update" class="form-control input-sm" maxlength="5" disabled="">
              <label>PDF</label>
              <input type="file" name="" id="pdf_update" class="form-control input-sm" disabled="">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-warning" id="actualiza_datos" data-dismiss="modal">Actualizar</button>
          </div>
        </div>
      </div>
    </div>

    </div>
</div>
</main>
  <div id="uploadResult" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Subir resultados</h4>
      <p>Selecciona los archivos necesarios para dar de alta el resultado <p>
      <form id="archivos-form"  method="post" enctype="multipart/form-data">
        <div class="row">
          <input type="hidden" name="resultado" id="modalResultado">
          <div class="col s12 m12 l6 file-field input-field">
            <div class="btn orange darken-4">
              <span>Buscar PDF</span>
              <input type="file" name="resultado_pdf[]" id="resultado_pdf" accept="application/pdf" multiple>
            </div>
            <div class="file-path-wrapper">
              <input class="file-path validate" type="text" placeholder="Selecciona un archivo PDF">
            </div>
          </div>
          <div class="col s12 m12 l6 file-field input-field">
            <div class="btn orange darken-4">
              <span>Buscar JPG</span>
              <input type="file" name="resultado_jpg[]" id="resultado_jpg" accept="image/jpeg" multiple>
            </div>
            <div class="file-path-wrapper">
              <input class="file-path validate" type="text" placeholder="Selecciona una imágen JPG">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col s12 m3 push-m9 right-align">
            <button class="s12 btn blue waves-effect waves-light" id="subir-archivos-resultados" data-form="archivos-form">Subir archivos <i class="material-icons right">cloud_upload</i></button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
    <script type="text/javascript">
    $(document).ready(function(){
        $('#tabla').load('componentes/tabla.php');
        $('#buscador').load('componentes/buscador.php');
    });
</script>
<script type="text/javascript">
    $(document).ready(function(){
       $('#actualiza_datos').click(function(){
           actualizaDatos();
       });
    });
</script>
  <script src="js/init.js"></script>
  <script>
    $(document).ready(function() {
      $('.modal').modal();
    });
  </script>
  <script src="js/resultados_controller.js"></script>
</body>
</html>
<?php 
}
else {
  header("Location: login.php");
}
