<?php
session_start();

if ($_SESSION['username'] && $_SESSION['user']) {
?>
<!DOCTYPE html>
<html lang="es">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0"/>
  <title>Médica Nuclear - Diagnostico con sentido humano</title>

  <!-- CSS  -->
  <link href="iconfont/material-icons.css" rel="stylesheet">
  <link href="../vendor/materialize/dist/css/materialize.min.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <link href="css/style.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <script src="../js/ajax.js"></script>
  <script src="../js/request.js"></script>
  <script src="../vendor/jquery/dist/jquery.min.js"></script>
  <script src="../vendor/materialize/dist/js/materialize.min.js"></script>
</head>
<body>
  <ul id="slide-out" class="side-nav fixed grey darken-4 white-text">
    <li class="logo">
      <a href="inicio" class="brand-logo">
        <img src="../img/Inicio/logomedicanuclear.png" alt="" width="200" heigth="350">
      </a>
    </li>
    <li><i class="material-icons left">person</i> <?php echo $_SESSION['username']; ?> </li>
    <li><a href="index.php" class="waves-effect waves-light"><h6>Inicio<i class="material-icons small right">home</i></h6></a></li>
    <li><a class="waves-effect waves-light active"><h6>Pacientes<i class="material-icons small right">people</i></h6></a></li>
    <li><a href="doctores.php" class="waves-effect waves-light"><h6>Doctores<i class="material-icons small right">person</i></h6></a></li>
    <li><a href="estudios.php" class="waves-effect waves-light"><h6>Estudios<i class="material-icons small right">work</i></h6></a></li>
    <li><a href="resultados.php" class="waves-effect waves-light"><h6>Resultados<i class="material-icons small right">assignment</i></h6></a></li>
    
    <li><a href="#!" class="center-align waves-effect waves-light light-blue darken-4" id="cerrar-sesion-boton"><h6>Salir <i class="material-icons small valign-m">power_settings_new</i></h6></a></li>
  </ul>
  <header>
    <nav class="light-blue darken-2 expanded">
      <div class="nav-wrapper">
        <a href="#" data-activates="slide-out" class="button-collapse"><i class="material-icons">menu</i></a>
        <a href="#" class="brand-logo">Médica Nuclear</a>
        
      </div>
    </nav>
  </header>
  <main>
    <div class="section">
      <div class="row">
        <div class="col s12">
          <div class="card-panel teal white-text">
            <span class="flow-text">Nuevo Paciente</span>            
              <form id="form-registrar-paciente">
                <div class="row">
                  <div class="input-field col s12 m2">
                    <input type="text" id="paciente_nuevo_paciente" class="validate" required pattern="[0-9]{1,10}" title="Sólo numeros">
                    <label class="white-text" for="paciente-nuevo-paciente" data-error="Sólo números">Expediente</label>
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col s12 m3">
                    <input type="text" id="paciente_nuevo_nombre" class="validate" required>
                    <label class="white-text" for="paciente-nuevo-nombre"> Nombre (s)</label>
                  </div>
                  <div class="input-field col s12 m3">
                    <input type="text" id="paciente_nuevo_apellidop" class="validate" required>
                    <label class="white-text" for="paciente-nuevo-apellidop"> Apellido Paterno</label>
                  </div>
                  <div class="input-field col s12 m3">
                    <input type="text" id="paciente_nuevo_apellidom" class="validate">
                    <label class="white-text" for="paciente-nuevo-apellidom"> Apellido Materno</label>
                  </div>
                  <div class="col s12 m3 white-text input-field">
                    <input type="date" id="paciente_nuevo_fn" class="validate" pattern="^(^[0-2]{1}[0-9]{1}|^[3]{1}[0-1]{1})\/([0]{1}[1-9]{1}|[1]{1}[0-2]{1})\/([1]{1}[9]{1}[0-9]{2}|[2]{1}[0]{1}[0-1]{1}[0-7]{1})"required placeholder="Fecha de Nacimiento">
                    <label class="white-text" for="paciente_editar_fn" data-error="Error: Fecha inválida"></label>
                  </div>
                </div>
                <div class="row">
                  <button class="s12 btn teal darken-3 waves-effect waves-light right" id="registra-paciente" data-form="form-registrar-paciente">Registrar</button>
                </div>
              </form>            
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col s12">
          <div class="card-panel simple indigo white-text">
            <span class="flow-text">Buscar Paciente</span>
            <div class="row">
              <form id="form-busca-paciente">
                <div class="input-field">
                  <input type="text" id="busca_paciente" data-form="form-busca-paciente">
                  <label class="white-text" for="busca_paciente">Expediente o Nombre</label>
                </div>
              </form>
            </div>
            <div class="indigo darken-3 grey-text">
              <ul class="lista discreto" id="lista-pacientes">
              </ul>            
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>
  <div id="modal-info" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Contraseña Paciente</h4>
    
      <code>Usuario: <span id="modal_paciente_user"></span></code> <br>
      <code>Contraseña: <span id="modal_paciente_pass"></span></code>
    </div>
    <div class="modal-footer grey darken-4">
      <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat white-text grey darken-2">Cerrar</a>
    </div>
  </div>
  <div id="modal-delete" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Borrar paciente</h4>
      <p>Está a punto de eliminar al paciente <span id="nombre-paciente-modal"></span></p>
    </div>
    <div class="modal-footer grey darken-4">
      <form id="borrar-paciente">
        <input type="hidden" id="delete_paciente">
        <button class="btn waves-effect waves-light red" data-form="borrar-paciente" id="confirma-eliminacion-paciente">Eliminar</button>
      </form>
    </div>
  </div>
  <div id="modal-edit" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Editar Paciente</h4>
      <form id="form-editar-paciente">
        <input type="hidden" id="paciente_edit_paciente">
        <div class="row">
          <div class="input-field col s12 m2">
            <input type="text" id="paciente_editar_expediente" class="validate" required pattern="[0-9]{1,10}" title="Sólo numeros">
            <label class="white-text" for="paciente_editar_expediente" data-error="Sólo números">Expediente</label>
          </div>
        </div>
        <div class="row">
          <div class="input-field col s12 m3">
            <input type="text" id="paciente_editar_nombre" class="validate" required>
            <label class="white-text" for="paciente_editar_nombre"> Nombre (s)</label>
          </div>
          <div class="input-field col s12 m3">
            <input type="text" id="paciente_editar_apellidop" class="validate" required>
            <label class="white-text" for="paciente_editar_apellidop"> Apellido Paterno</label>
          </div>
          <div class="input-field col s12 m3">
            <input type="text" id="paciente_editar_apellidom" class="validate">
            <label class="white-text" for="paciente_editar_apellidom"> Apellido Materno</label>
          </div>
          <div class="col s12 m3 white-text input-field">
            <input type="date" id="paciente_editar_fn" class="validate" pattern="^(^[0-2]{1}[1-9]{1}|^[3]{1}[0-1]{1})\/([0]{1}[1-9]{1}|[1]{1}[0-2]{1})\/([1]{1}[9]{1}[0-9]{2}|[2]{1}[0]{1}[0-1]{1}[0-7]{1})"required>
            <label class="white-text" for="paciente_editar_fn" data-error="Error: Fecha inválida"></label>
          </div>
        </div>
        <div class="row">
          <button class="s12 btn teal darken-3 waves-effect waves-light right" id="actualizar-paciente" data-form="form-editar-paciente">Actualizar</button>
        </div>
      </form>
    </div>
    <div class="modal-footer grey darken-4">
      <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat white-text grey darken-2">Cerrar</a>
    </div>
  </div>
  <script>
    $('.modal').modal();
  </script>
  <script src="js/init.js"></script>
  <script src="js/pacientes_controller.js"></script>
</body>
</html>
<?php 
}
else {
  header("Location: login.php");
}
