<?php
session_start();

if(count($_SESSION)) {
  
  if ($_SESSION['username'] && $_SESSION['user']) {
    
    header("Location: index.php");
  }
}
else {
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0"/>
  <title>Médica Nuclear - Diagnostico con sentido humano</title>

  <!-- CSS  -->
  <link href="iconfont/material-icons.css" rel="stylesheet">
  <link href="../vendor/materialize/dist/css/materialize.min.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <link href="css/style.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <script src="../js/ajax.js"></script>
  <script src="../js/request.js"></script>
  <script src="../vendor/jquery/dist/jquery.min.js"></script>
  <script src="../vendor/materialize/dist/js/materialize.min.js"></script>
</head>
<body>
  <nav class="light-blue darken-2 expanded">
    <div class="nav-wrapper">
      <a href="#" class="brand-logo">Médica Nuclear</a>
    </div>
  </nav>
  <div class="section">
    <div class="row">
      <div class="col s12 m6 push-m3 l4 push-l4 center-align">
        <h5>Bienvenido al panel de control de Médica Nuclear</h5>
        <p>
          Esta sección está restringida al personal autorizado, para continuar favor de ingresar su usuario y contraseña
        </p>
        <div class="row">
          <div class="col s12">
            <div class="card-panel blue">
              <form id="login-form">
                <div class="input-field white-text">
                  <input type="text" id="user_panel" class="validate" required>
                  <label class="white-text" for="user_panel">Usuario</label>
                </div>
                <div class="input-field white-text">
                  <input type="password" id="pass_panel" class="validate" required>
                  <label class="white-text" for="pass_panel">Contraseña</label>
                </div>
                <button class="btn waves-light waves-effect green" data-form="login-form" id="login-button">Iniciar Sesión</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <script src="js/init.js"></script>
  <script src="js/login_controller.js"></script>
</body>
</html>
<?php 
}