<?php
session_start();

if ($_SESSION['username'] && $_SESSION['user']) {
?>
<!DOCTYPE html>
<html lang="es">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0"/>
  <title>Médica Nuclear - Diagnostico con sentido humano</title>

  <!-- CSS  -->
  <link href="iconfont/material-icons.css" rel="stylesheet">
  <link href="../vendor/materialize/dist/css/materialize.min.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <link href="css/style.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <script src="../js/ajax.js"></script>
  <script src="../js/request.js"></script>
  <script src="../vendor/jquery/dist/jquery.min.js"></script>
  <script src="../vendor/materialize/dist/js/materialize.min.js"></script>
  <script src="../js/ajax.js"></script>
  <script src="../js/request.js"></script>
</head>
<body>
  <ul id="slide-out" class="side-nav fixed grey darken-4 white-text">
    <li class="logo">
      <a href="inicio" class="brand-logo">
        <img src="../img/Inicio/logomedicanuclear.png" alt="" width="200" heigth="350">
      </a>
    </li>
    <li><i class="material-icons left">person</i> <?php echo $_SESSION['username']; ?> </li>
    <li><a href="index.php" class="waves-effect waves-light"><h6>Inicio<i class="material-icons small right">home</i></h6></a></li>
    <li><a href="pacientes.php" class="waves-effect waves-light"><h6>Pacientes<i class="material-icons small right">people</i></h6></a></li>
    <li><a href="doctores.php" class="waves-effect waves-light"><h6>Doctores<i class="material-icons small right">person</i></h6></a></li>
    <li><a class="waves-effect waves-light active"><h6>Estudios<i class="material-icons small right">work</i></h6></a></li>
    <li><a href="resultados.php" class="waves-effect waves-light"><h6>Resultados<i class="material-icons small right">assignment</i></h6></a></li>
    
    <li><a href="#!" class="center-align waves-effect waves-light light-blue darken-4" id="cerrar-sesion-boton"><h6>Salir <i class="material-icons small valign-m">power_settings_new</i></h6></a></li>
  </ul>
  <header>
    <nav class="light-blue darken-2 expanded">
      <div class="nav-wrapper">
        <a href="#" data-activates="slide-out" class="button-collapse"><i class="material-icons">menu</i></a>
        <a href="#" class="brand-logo">Médica Nuclear</a>
        
      </div>
    </nav>
  </header>
  <main>
    <div class="section">
      <div class="row">
        <div class="col s12">
          <div class="card-panel teal white-text">
            <span class="flow-text">Nuevo Estudio</span>            
            <form id="form_registrar_estudio">
              <div class="row">
                <div class="input-field col s12 m2">
                  <input type="text" id="estudio_nuevo_clave" class="validate" required title="Sólo numeros">
                  <label class="white-text" for="estudio-nuevo-clave">Clave</label>
                </div>
                <div class="input-field col s12 m5">
                  <select id="estudio_nuevo_categoria" required class="validate">
                  </select>
                  <label>Escoge una opción</label>
                </div>
                <div class="input-field col s12 m5">
                  <input type="text" id="estudio_nuevo_estudio" class="validate" required>
                  <label class="white-text" for="estudio-nuevo-estudio"> Estudio</label>
                </div>
              </div>
              <div class="row">
                <div class="input-field col s12 m3">
                  <input type="text" id="estudio_nuevo_entrega" class="validate" required>
                  <label class="white-text" for="estudio-nuevo-entrega">Entrega</label>
                </div>
                <div class="input-field col s12 m3">
                  <input type="text" id="estudio_nuevo_precio" class="validate" required>
                  <label class="white-text" for="estudio-nuevo-precio">Precio</label>
                </div>
                <div class="input-field col s12 m6">
                  <input type="text" id="estudio_nuevo_indicaciones" class="validate" required>
                  <label class="white-text" for="estudio-nuevo-indicaciones">Indicaciones</label>
                </div>
              </div>
              <div class="row">
                <button class="s12 btn teal darken-3 waves-effect waves-light right" id="registrar_nuevo_estudio" data-form="form_registrar_estudio">Registrar</button>
              </div>
            </form>            
          </div>
        </div>
        <div class="col s12">
          <div class="card-panel green white-text">
            <span class="flow-text">Nueva Categoría</span>            
            <form id="form_categoria_nueva">
              <div class="row">
                <div class="col s12 m9">
                  <div class="input-field">
                    <input type="text" id="estudio_categoria_nueva" class="validate" required>
                    <label for="estudio_categoria_nueva" class="white-text">Categoría</label>
                  </div>
                </div>
                <div class="col s12 m3">
                  <button class="s12 btn green darken-3 waves-effect waves-light right" id="registrar-nueva-categoria" data-form="form_categoria_nueva">Registrar</button>
                </div>
              </div>
            </form> 
            <span class="flow-text">Catálogo de categorias</span>            
            <form id="form-registrar-especialidad">
              <div class="row">
                <div class="green darken-3 grey-text">
                  <ul class="lista discreto" id="list-categorias">
                  </ul>            
                </div>
              </div>
            </form>             
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col s12">
          <div class="card-panel simple indigo white-text">
            <span class="flow-text">Buscar Estudio</span>
            <div class="row">
              <form id="form-busca-estudio">
                <div class="input-field">
                  <input type="text" id="busca_estudio" data-form="form-busca-estudio">
                  <label class="white-text" for="busca_estudio">Clave o Nombre</label>
                </div>
              </form>
            </div>
            <div class="indigo darken-3 grey-text">
              <ul class="lista discreto" id="lista-estudios">
              </ul>            
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>
  <div id="editEstudioModal" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <span class="flow-text">Editar Estudio</span>            
      <form id="form_edit_estudio">
        <div class="row">
          <input type="hidden" id="estudio_editar_reg">
          <div class="input-field col s12 m2">
            <input type="text" id="estudio_edit_clave" class="validate" required title="Sólo numeros">
            <label class="white-text" for="estudio-nuevo-clave">Clave</label>
          </div>
          <div class="input-field col s12 m5">
            <select id="estudio_edit_categoria" required class="validate">
            </select>
            <label>Escoge una opción</label>
          </div>
          <div class="input-field col s12 m5">
            <input type="text" id="estudio_edit_estudio" class="validate" required>
            <label class="white-text" for="estudio-nuevo-estudio"> Estudio</label>
          </div>
        </div>
        <div class="row">
          <div class="input-field col s12 m3">
            <input type="text" id="estudio_edit_entrega" class="validate" required>
            <label class="white-text" for="estudio-nuevo-entrega">Entrega</label>
          </div>
          <div class="input-field col s12 m3">
            <input type="text" id="estudio_edit_precio" class="validate" required>
            <label class="white-text" for="estudio-nuevo-precio">Precio</label>
          </div>
          <div class="input-field col s12 m6">
            <input type="text" id="estudio_edit_indicaciones" class="validate" required>
            <label class="white-text" for="estudio-nuevo-indicaciones">Indicaciones</label>
          </div>
        </div>
        <div class="row">
          <button class="btn green darken-3 waves-effect waves-light right" id="editar_estudio_button" data-form="form_edit_estudio">Actualizar</button>
        </div>
      </form>
    </div>
    <div class="modal-footer grey darken-4">
      <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat white-text grey darken-2">Cerrar</a>
    </div>
  </div>
  <div id="editCategoria" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Modificar Categoria</h4>
      <p>Ingresa la nueva categoria<p>
      <form id="edit-espec">
        <div class="input-field"><input type="text" id="edit_categoria_input"></div>
        <input type="hidden" id="edit_categoria_id">
        <button class="btn waves-effect waves-light blue white-text" id="edit_cat_button" data-form="edit-espec">Actualizar</button>
      </form>
    </div>
  </div>
  <div id="deleteCategoria" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Eliminar Categoria</h4>
      <p>¿Estás seguro que deseas eliminar la categoria <u><strong id="nombre-specs"></strong></u>?</p>
      <form id="delete-espec">
        <input type="hidden" id="delete_categoria_confirm">
        <button class="btn waves-effect waves-light red white-text" id="delete_cat_button" data-form="delete-espec">Eliminar</button>
      </form>
    </div>
  </div>
  <script src="js/init.js"></script>
  <script>
    $('.modal').modal();
  </script>
  <script src="js/estudios_controller.js"></script>
</body>
</html>
<?php 
}
else {
  header("Location: login.php");
}
