<?php
session_start();


if ($_SESSION['username'] && $_SESSION['user']) {
?>
<!DOCTYPE html>
<html lang="es">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0"/>
  <title>Médica Nuclear - Diagnostico con sentido humano</title>

  <!-- CSS  -->
  <link href="iconfont/material-icons.css" rel="stylesheet">
  <link href="../vendor/materialize/dist/css/materialize.min.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <link href="css/style.css" type="text/css" rel="stylesheet" media="screen,projection"/>
  <script src="../js/ajax.js"></script>
  <script src="../js/request.js"></script>
  <script src="../vendor/jquery/dist/jquery.min.js"></script>
  <script src="../vendor/materialize/dist/js/materialize.min.js"></script>
</head>
<body>
  <ul id="slide-out" class="side-nav fixed grey darken-4 white-text">
    <li class="logo">
      <a href="inicio" class="brand-logo">
        <img src="../img/Inicio/logomedicanuclear.png" alt="" width="200" heigth="350">
      </a>
    </li>
    <li><i class="material-icons left">person</i> <?php echo $_SESSION['username']; ?> </li>
    <li><a href="index.php" class="waves-effect waves-light"><h6>Inicio<i class="material-icons small right">home</i></h6></a></li>
    <li><a href="pacientes.php" class="waves-effect waves-light"><h6>Pacientes<i class="material-icons small right">people</i></h6></a></li>
    <li><a class="waves-effect waves-light active"><h6>Doctores<i class="material-icons small right">person</i></h6></a></li>
    <li><a href="estudios.php" class="waves-effect waves-light"><h6>Estudios<i class="material-icons small right">work</i></h6></a></li>
    <li><a href="resultados.php" class="waves-effect waves-light"><h6>Resultados<i class="material-icons small right">assignment</i></h6></a></li>
    
    <li><a href="#!" class="center-align waves-effect waves-light light-blue darken-4" id="cerrar-sesion-boton"><h6>Salir <i class="material-icons small valign-m">power_settings_new</i></h6></a></li>
  </ul>
  <header>
    <nav class="light-blue darken-2 expanded">
      <div class="nav-wrapper">
        <a href="#" data-activates="slide-out" class="button-collapse"><i class="material-icons">menu</i></a>
        <a href="#" class="brand-logo">Médica Nuclear</a>
        
      </div>
    </nav>
  </header>
  <main>
    <div class="section">
      <div class="row">
        <div class="col s12">
          <div class="card-panel teal white-text">
            <span class="flow-text">Nuevo Doctor</span>            
            <form id="form-nuevo-doctor">
              <div class="row">
                <div class="input-field col s12 m2">
                  <input type="text" name="doctor_nuevo_expediente" id="doctor_nuevo_expediente" class="validate" required title="Sólo numeros">
                  <label class="white-text" for="doctor_nuevo_expediente" data-error="Sólo números">Clave de control</label>
                </div>
              </div>
              <div class="row">
                <div class="input-field col s12 m4">
                  <input type="text" name="doctor_nuevo_nombre" id="doctor_nuevo_nombre" class="validate" required>
                  <label class="white-text" for="doctor_nuevo_nombre"> Nombre (s)</label>
                </div>
                <div class="input-field col s12 m4">
                  <input type="text" name="doctor_nuevo_apellidop" id="doctor_nuevo_apellidop" class="validate" required>
                  <label class="white-text" for="doctor_nuevo_apellidop"> Apellido Paterno</label>
                </div>
                <div class="input-field col s12 m4">
                  <input type="text" name="doctor_nuevo_apellidom" id="doctor_nuevo_apellidom" class="validate">
                  <label class="white-text" for="doctor_nuevo_apellidom"> Apellido Materno</label>
                </div>
              </div>
              <div class="row">
                <div class="input-field col s12 m4">
                  <select id="doctor_nuevo_especialidad">
                    <option value="" disabled selected>Especialidad</option>
                  </select>
                  <label>Escoge una opción</label>
                </div>
                <div class="input-field col s12 m4">
                  <input type="tel" name="doctor_nuevo_telefono" id="doctor_nuevo_telefono" class="validate" required>
                  <label class="white-text" for="doctor_nuevo_telefono" data-error="Sólo números 8 ó 10"> Teléfono</label>
                </div>
                <div class="input-field col s12 m4">
                  <input type="email" name="doctor_nuevo_email" id="doctor_nuevo_email" class="validate">
                  <label class="white-text" for="doctor_nuevo_email" data-error="Ingresa un correo válido">Correo Electrónico</label>
                </div>
                <button class="s12 btn teal darken-3 waves-effect waves-light right" id="registrar-doctores" data-form="form-nuevo-doctor">Registrar</button>
              </div>
            </form>            
          </div>
        </div>
        <div class="col s12">
          <div class="card-panel green white-text">
            <span class="flow-text">Nueva Especialidad</span>            
            <form id="form-registrar-especialidad">
              <div class="row">
                <div class="col s12 m9">
                  <div class="input-field">
                    <input type="text" name="especialidad_nueva" id="especialidad_nueva" class="validate" required>
                    <label for="especialidad-nueva" class="white-text">Especialidad</label>
                  </div>
                </div>
                <div class="col s12 m3">
                  <button class="s12 btn green darken-3 waves-effect waves-light right" id="registrar-especialidad" data-form="form-registrar-especialidad">Registrar</button>
                </div>
              </div>
            </form> 
            <span class="flow-text">Catálogo de categorias</span>            
            <form id="form-registrar-especialidad">
              <div class="row">
                <div class="green darken-3 grey-text">
                  <ul class="lista discreto" id="list-especialidades">
                  </ul>            
                </div>
              </div>
            </form>                       
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col s12">
          <div class="card-panel simple indigo white-text">
            <span class="flow-text">Buscar Doctor</span>
            <div class="row">
              <form id="form-busca-doctor">
                <div class="input-field">
                  <input type="text" id="busca_doctor" data-form="form-busca-doctor">
                  <label class="white-text" for="busca_doctor">Expediente o Nombre</label>
                </div>
              </form>
            </div>
            <div class="indigo darken-3 grey-text">
              <ul class="lista discreto" id="lista-doctores">
              </ul>            
            </div>
          </div>
        </div>
      </div>
    </div>
  </main> 
  <div id="editDoctorModal" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <span class="flow-text">Editar Doctor</span>            
  <form id="form-edit-doctor">
  <input type="hidden" id="id_doctor_editar_app">
    <div class="row">
      <div class="input-field col s12 m2">
        <input type="text" name="doctor_editar_expediente" id="doctor_editar_expediente" class="validate" required title="Sólo numeros">
        <label class="white-text" for="doctor_editar_expediente" data-error="Sólo números">Clave de control</label>
      </div>
    </div>
    <div class="row">
      <div class="input-field col s12 m4">
        <input type="text" name="doctor_editar_nombre" id="doctor_editar_nombre" class="validate" required>
        <label class="white-text" for="doctor_editar_nombre"> Nombre (s)</label>
      </div>
      <div class="input-field col s12 m4">
        <input type="text" name="doctor_editar_apellidop" id="doctor_editar_apellidop" class="validate" required>
        <label class="white-text" for="doctor_editar_apellidop"> Apellido Paterno</label>
      </div>
      <div class="input-field col s12 m4">
        <input type="text" name="doctor_editar_apellidom" id="doctor_editar_apellidom" class="validate">
        <label class="white-text" for="doctor_editar_apellidom"> Apellido Materno</label>
      </div>
    </div>
    <div class="row">
      <div class="input-field col s12 m4">
        <select id="doctor_editar_especialidad">
          <option value="" disabled selected>Especialidad</option>
        </select>
        <label>Escoge una opción</label>
      </div>
      <div class="input-field col s12 m4">
        <input type="tel" name="doctor_editar_telefono" id="doctor_editar_telefono" class="validate" required>
        <label class="white-text" for="doctor_editar_telefono" data-error="Sólo números 8 ó 10"> Teléfono</label>
      </div>
      <div class="input-field col s12 m4">
        <input type="email" name="doctor_editar_email" id="doctor_editar_email" class="validate">
        <label class="white-text" for="doctor_editar_email" data-error="Ingresa un correo válido">Correo Electrónico</label>
      </div>
      <button class="s12 btn blue darken-3 waves-effect waves-light right" id="editar-doctores" data-form="form-edit-doctor">Actualizar</button>
    </div>
  </form> 
    </div>
    <div class="modal-footer grey darken-4">
      <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat white-text grey darken-2">Cerrar</a>
    </div>
  </div>
  <div id="info" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Acceso a doctores</h4>
      <p>Doctor: </p>
      <code>Usuario: <span id="cnt-p"></span> </code>
      <code>Contraseña: <span id="cnt-u"></span> </code>
    </div>
    <div class="modal-footer grey darken-4">
      <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat white-text grey darken-2">Cerrar</a>
    </div>
  </div>
  <div id="editEspecialidad" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Modificar Especialidad</h4>
      <p>Ingresa la nueva especialidad<p>
      <form id="edit-espec">
        <div class="input-field"><input type="text" id="edit_espec_input"></div>
        <input type="hidden" id="edit_espec_id">
        <button class="btn waves-effect waves-light blue white-text" id="edit_esp_button" data-form="edit-espec">Actualizar</button>
      </form>
    </div>
  </div>
  <div id="deleteEspecialidad" class="modal grey darken-3 white-text">
    <div class="modal-content">
      <h4>Eliminar Especialidad</h4>
      <p>¿Estás seguro que deseas eliminar la especialidad <u><strong id="nombre-specs"></strong></u>?</p>
      <form id="delete-espec">
        <input type="hidden" id="delete_espec_confirm">
        <button class="btn waves-effect waves-light red white-text" id="delete_esp_button" data-form="delete-espec">Eliminar</button>
      </form>
    </div>
  </div>
  <script>
    $('.modal').modal();
  </script>
  <script src="js/init.js"></script>
  <script src="js/doctores_controllers.js"></script>
</body>
</html>
<?php 
}
else {
  header("Location: login.php");
}
