<?php 
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Administradores;
use CorePHP\Models\Auth;


header('Content-Type: text/html; charset=utf-8');

class SessionController 
{

  private $_session = null;
  private $_data = null;

  public function __construct($argument)
  {

    try {
      $this->_admin = new Administradores();
      $this->_auth = new Auth();
      $this->_data = $argument;
      $this->__init__();
    }

    catch (\Exception $e) {

      echo "Constructor " . $e->getMessage();

    }

  }

  public function __init__() 
  { 
    session_start();

    extract($this->_data);

    if (isset($route)) {

      if($route == "" || is_numeric($route)){

        echo "Error: dirección desconocida";
      }
      else {
        if (isset($_SESSION['user']) && isset($_SESSION['username'])) {

          $user = $_SESSION['user'];
          $username = $_SESSION['username'];

          if ($this->_admin->auth($user,$username)) {

            if ($route == "default") {

              $route_default = $this->_auth->routeDefalut($this->_admin->tipo);
              
              $response = array(
                  'access' => true,
                  'status' => 1,
                  'content' => "Bienvenido $username",
                  'route' => $route_default
                  );

                echo json_encode($response, JSON_FORCE_OBJECT);

            }
            else {
              if ($this->_auth->route($route,$this->_admin->tipo)) {

                $response = array(
                  'access' => true,
                  'status' => 1,
                  'content' => "Bienvenido $username"
                  );

                echo json_encode($response, JSON_FORCE_OBJECT);
              }
              else {
                $response = array(
                  'access' => false,
                  'status' => 2,
                  'content' => "Acceso no autorizado"
                  );

                echo json_encode($response, JSON_FORCE_OBJECT);
              }
            }
          }
          else {
            $response = array(
              'access' => false,
              'status' => 4,
              'content' => "Sesión Corrupta"
              );

            echo json_encode($response, JSON_FORCE_OBJECT);
          }
        }
        else {
          $response = array(
            'access' => false,
            'status' => 3,
            'content' => "La sesión ha caducado"
            );

          echo json_encode($response, JSON_FORCE_OBJECT);
        }
      }
    }
    else {
      echo "Parámetros desconocidos";
    }
  }
}

if ($_POST) {
  new SessionController($_POST);
}
else {
  echo "Solcitud Inválida";
}