<?php 
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use Controllers\SessionController;
use CorePHP\Models\Auth;


header('Content-Type: text/html; charset=utf-8');

class RouterController 
{

  private $_session = null;
  private $_data = null;
  private $_auth = null;

  public function __construct($argument)
  {

    try {
      $this->_auth = new Auth();
      $this->_session = new SessionController();
      $this->_data = $argument;
      $this->__init__();
    }

    catch (\Exception $e) {

      echo "Constructor " . $e->getMessage();

    }

  }

  public function __init__() 
  { 
    if (count($this->_data) > 1) {
      echo "Error: Parámetros inválidos";
    }
    else {
      extract($this->_data);

      if (isset($route)) {
       
        if($route == "" || is_numeric($route){
       
          echo "Error: dirección desconocida";
        }
        else {
       
          if ($error_session = $this->_session->error()) {
       
            return $error_session;
          }
       
          else {
       
            $tipo = $this->_session->getType();

            if($route == "default") {
              $default_route = $this->_auth->routeDefault();
              $response = array(
                'access' => true,
                'status' => 1,
                'content' => "Bienvenido $username",
                'route' => $default_route
                );

              echo json_encode($response, JSON_FORCE_OBJECT);
            }
            else {
              if ($this->_auth->route($route,$tipo)) {

              $response = array(
                'access' => true,
                'status' => 1,
                'content' => "Bienvenido $username"
                );

              echo json_encode($response, JSON_FORCE_OBJECT);
            }
            else {
              $response = array(
                'access' => false,
                'status' => 2,
                'content' => "Acceso no autorizado"
                );

              echo json_encode($response, JSON_FORCE_OBJECT);
            }
            }
          }
        }
      }
    }
  }
}

if ($_POST) {
  new RouterController($_POST);
}
else {
  echo "Error: Solicitud no autorizada";
}