<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Estudios;
use CorePHP\Models\Doctores;
use CorePHP\Models\Pacientes;
use CorePHP\Models\Resultados;
                                                
header('Content-Type: text/html; charset=utf-8');

class ResultadosControllerPost
{
  private $_data = null;
  private $_instancePacientes  = null;
  private $_instanceDoctores = null;
  private $_instanceEstudios  = null;
  private $_instanceResultados = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceEstudios = new Estudios();
      $this->_instanceDoctores = new Doctores();
      $this->_instancePacientes = new Pacientes();
      $this->_instanceResultados = new Resultados();    
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    
    extract($this->_data);

    $code = ""; 

    if ( isset($nuevo_resultado_paciente) && isset($nuevo_resultado_doctor) && isset($nuevo_resultado_estudio) && isset($nuevo_resultado_fecha)) {
      if ( $nuevo_resultado_paciente != "" && $nuevo_resultado_doctor != "" && $nuevo_resultado_estudio != "" && $nuevo_resultado_fecha != "") {

        if($this->_instancePacientes->getItemById($nuevo_resultado_paciente)){

          if ($this->_instanceEstudios->getItemById($nuevo_resultado_estudio)) {
            
            if ($this->_instanceDoctores->getItemById($nuevo_resultado_doctor)) {
              
              $item = array(
                "paciente" => $this->_instancePacientes->id_Paciente,
                "estudio" => $this->_instanceEstudios->id_Estudio,
                "doctor" => $this->_instanceDoctores->id_Doctor,
                "fecha" => $nuevo_resultado_fecha
              );

              $this->_instanceResultados->insertItemAssignation($item);

              echo "Resultado Agregado Correctamente";
            }
            else{
              echo "Clave de doctor desconocida<br>";
            }
          }
          else {
            echo "Clave de estudio desconocida<br>";
          }
        }
        else {
          echo "Expediente de paciente desconocido<br>";
        }
      }
      else {
        echo "Error: Campos vacíos o incorrectos";
      }
    }
    else if ($list) {
      $resultados = $this->_instanceResultados->getList();

      if (count($resultados)) {
        foreach ($resultados as $resultado) {
          $code .= "
            <li class='elements-inline'>
              <i class='material-icons right upload-resultado'>assignment</i>
              <span class='right-align text-resultado' val='$resultado->id'>$resultado->paciente - $resultado->estudio</span>
            </li>
          ";
        }
      }
      else {
        $code .= "
            <li class='elements-inline'>
              <h5>No se encontraron resultados</h5>
            </li>
          ";
      }

      echo $code;
    }
    else {
      echo "Error: Parámetros Incorrectos";
    }
  }
}

class ResultadosControllerFiles
{
  private $_data = null;
  private $_instancePacientes  = null;
  private $_instanceDoctores = null;
  private $_instanceEstudios  = null;
  private $_instanceResultados = null;
  private $_dir_resultados = null;
  private $_file_pdf = null;
  private $_file_jpg = null;
  private $_error_msg = null;



  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceEstudios = new Estudios();
      $this->_instanceDoctores = new Doctores();
      $this->_instancePacientes = new Pacientes();
      $this->_instanceResultados = new Resultados();
      $this->_dir_resultados = __DIR__ . "/../resultados/";
      $this->_file_pdf = array();
      $this->_file_jpg = array();
      $this->_error_msg = "";
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {

    extract($this->_data);

    extract($_POST);

    if ($this->typePDF($resultado_pdf) && $this->typeJPG($resultado_jpg)){
      $this->registraArchivos($resultado);
    }
  }

  private function typePDF($eva)
  {
    $response = true;

    $err = $eva['error'];

    foreach ($err as $key => $value) {
     
      if ($value == 4) {
        
        $this->_error_msg.= $eva['name'][$key] . "No ha podido subirse al servidor<br>" ;
        if ($response){
          $response = false;
        }
      }
      
      else {
        
        if ($eva['type'][$key] != "application/pdf") {
         
          $this->_error_msg.= $eva['name'][$key] . "No es un archivo PDF<br>" ;
          if ($response){
            $response = false;
          }
        }
      }
    }

    if ($response) {

      $tmp = $eva['tmp_name'];
      
      foreach ($tmp as $value) {
        
        $this->_file_pdf[] = $file_pdf = uniqid('res_');
        
        $resultado_file_pdf = $this->_dir_resultados . basename($file_pdf);

        if (move_uploaded_file($value, $resultado_file_pdf)) {
            
            echo "PDF válido y subido con exito.<br>";

          } else {
            
            echo "Error al subir el archivo PDF<br>";

          }
      }
    }

    return $response;
  }

  private function typeJPG($eva)
  {
    $response = true;

    $err = $eva['error'];

    foreach ($err as $key => $value) {
     
      if ($value == 4) {
        
        $this->_error_msg.= $eva['name'][$key] . "No ha podido subirse al servidor<br>" ;
        if ($response){
          $response = false;
        }
      }
      
      else {
        
        if ($eva['type'][$key] != "image/jpeg") {
         
          $this->_error_msg.= $eva['name'][$key] . "No es una imagen JPG<br>" ;
          if ($response){
            $response = false;
          }
        }
      }
    }

    if ($response) {

      $tmp = $eva['tmp_name'];
      
      foreach ($tmp as $value) {
        
        $this->_file_jpg[] = $file_jpg = uniqid('res_');
        
        $resultado_file_jpg = $this->_dir_resultados . basename($file_jpg);

        if (move_uploaded_file($value, $resultado_file_jpg)) {
            
            echo "JPG válido y subido con exito.<br>";

          } else {
            
            echo "Error al subir la imagen JPG<br>";

          }
      }
    }

    return $response;
  }

  private function registraArchivos($resultado)
  {

    if (count($this->_file_pdf)) {

      $item  = array(
        'pdf' => implode(',', $this->_file_pdf),
        'id' => $resultado
      );

      $this->_instanceResultados->assignPDF($item);
    }

    if (count($this->_file_jpg)) {

      $item  = array(
        'jpg' => implode(',', $this->_file_jpg),
        'id' => $resultado
      );

      $this->_instanceResultados->assignJPG($item);
    }

    $estatus = array(
      "estatus" => 1,
      "id" => $resultado
      );

    $this->_instanceResultados->cambiaEstatus($estatus);
  }
}

if($_FILES){
  new ResultadosControllerFiles($_FILES);
}
else if($_POST){
  new ResultadosControllerPost($_POST);
}
else{
  echo "Error POST";
}

