<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Pacientes;
use CorePHP\Models\Resultados;
                                                        
header('Content-Type: text/html; charset=utf-8');

class DoctoresController
{
  private $_data = null;
  private $_instancePacientes  = null;
  private $_instanceResultados = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instancePacientes = new Pacientes();
      $this->_instanceResultados = new Resultados();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    if (isset($list)) {
      $this->listaResultados();
    }
    else if (isset($stats)) {
      $this->regresaConteo();
    }
    else if (isset($files) && $files != "") {
      $this->muestraArchivos($files);
    }
  }

  private function listaResultados() {
    $resultados = $this->_instanceResultados->getHistorial();
    $code = "<ul class='collection'>";

    foreach ($resultados as $resultado) {
      $code .= "
        <li class='collection-item elements-inline'>
      ";

      if ($resultado->estatus == "1") {
        $code .= "<i class='material-icons small right show_files' val='$resultado->id'>assignment</i>";
        
      }
      $code .= "
          <span class='right'>$resultado->fecha</span>
          <span class='right-align text-resultado'>$resultado->paciente - $resultado->estudio</span>
        </li>
      ";
    } 

    $code .= "</ul>";

    echo $code;
  }

  private function regresaConteo() {
    $this->_instanceResultados->count();

    echo $this->_instanceResultados->numero;
  }

  private function muestraArchivos($id) {
    $this->_instanceResultados->getFiles($id);

    $pdfs = explode(',', $this->_instanceResultados->pdf);
    $jpgs = explode(',', $this->_instanceResultados->img);

    $code = "<div class='row'>";

    foreach ($jpgs as $jpg) {
      $code .= "<div class='col s12 m3'><div class='thumbnail'><a href='resultados/$jpg' target='_blank'><img src='resultados/$jpg'/></a></div></div>";
    }

    foreach ($pdfs as $pdf) {
      $code .= "<div class='col s12 m3'><div class='thumbnail'><a href='resultados/$pdf' target='_blank'><img src='../img/iconos/file-pdf.svg' /></a></div></div>";
    }

    $code .= "</div>";

    echo $code; 
  }
}
if($_POST){
  new DoctoresController($_POST);
}else{
  echo "Error POST";
}

