<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Pacientes;

header('Content-Type: text/html; charset=utf-8');

class PacientesController
{
  private $_data = null;
  private $_instancePacientes  = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instancePacientes = new Pacientes();
      $this->__init__();
    }
    catch (\Exception $e) {

      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    $code = ""; 

    if (isset($busca_paciente)) {

      if ($busca_paciente != "") {

        $pacientes = $this->_instancePacientes->getItemSearch($busca_paciente);

        if (count($pacientes)) {

          foreach ($pacientes as $paciente) {

            $code .= "
            <li class='elements-inline'>
              <i class='material-icons right' id='deletePaciente'>delete</i>
              <i class='material-icons right' id='editPaciente'>edit</i>
              <i class='material-icons right' id='infoPaciente'>lock</i>
              <span id='lista-expediente-paciente'>$paciente->expediente</span>
              <span val='$paciente->id' id='lista-nombre-paciente' data-app='$paciente->app'>". $paciente->nombre . " " . $paciente->app . " " . $paciente->apm ."</span>
            </li>
            ";
          }

          echo $code;
        }
        else {
          echo "
          <li class='elements-inline'>
            <h5>No se encontraron resultados</h5>
          </li>
          ";
        }
      }

    }
    else if(isset($edit_paciente)) {

      $this->_instancePacientes->getItem($edit_paciente);

      header('Content-Type: application/json');

      echo "{
        \"id\": \"".$this->_instancePacientes->id_Paciente."\",
        \"nombre\": \"".$this->_instancePacientes->nombre."\",
        \"app\": \"".$this->_instancePacientes->apellido_paterno."\",
        \"apm\": \"".$this->_instancePacientes->apellido_materno."\",
        \"fecha\": \"".$this->_instancePacientes->fecha_nacimiento."\",
        \"expediente\": \"".$this->_instancePacientes->expediente."\"
      }";
    }
    else if(isset($delete_paciente)) {
      if ($delete_paciente != "") {
        $this->_instancePacientes->deleteItem($delete_paciente);

        echo "Paciente eliminado exitosamente";
      }
    }
    else if(isset($paciente_nuevo_paciente)  && isset($paciente_nuevo_nombre)  && isset($paciente_nuevo_apellidop)  && isset($paciente_nuevo_apellidom)  && isset($paciente_nuevo_fn)) {

      if($paciente_nuevo_paciente != ""  && $paciente_nuevo_nombre != ""  && $paciente_nuevo_apellidop != ""  && $paciente_nuevo_apellidom != ""  && $paciente_nuevo_fn != "") {

        $item = array(
          "nombre" => $paciente_nuevo_nombre,
          "apellido_paterno" => $paciente_nuevo_apellidop,
          "apellido_materno" => $paciente_nuevo_apellidom,
          "fecha_nacimiento" => $paciente_nuevo_fn,
          "expediente" => $paciente_nuevo_paciente
          );

        $this->_instancePacientes->insertItem($item);

        echo "{\"state\": true, \"context\": \"Paciente agregado a la base\"}";
      }
    }
    else if(isset($paciente_edit_paciente)  && isset($paciente_editar_expediente)  && isset($paciente_editar_nombre)  && isset($paciente_editar_apellidop)  && isset($paciente_editar_apellidom) &&isset($paciente_editar_fn)) {

      if($paciente_edit_paciente != ""  && $paciente_editar_expediente != ""  && $paciente_editar_nombre != ""  && $paciente_editar_apellidop != ""  && $paciente_editar_apellidom != "" && $paciente_editar_fn != "") {

        $item = array(
          "nombre" => $paciente_editar_nombre,
          "apellido_paterno" => $paciente_editar_apellidop,
          "apellido_materno" => $paciente_editar_apellidom,
          "fecha_nacimiento" => $paciente_editar_fn,
          "expediente" => $paciente_editar_expediente
          );

        $this->_instancePacientes->updateItem($paciente_edit_paciente,$item);

        echo "Datos de paciente actualizados";
      }
      else {
        echo "Error: Campos Vacios";
      }
    }
    else {
      echo "Error: Solicitud Invalida";
    }
  }
}
if($_POST){
  new PacientesController($_POST);
}else{
  echo "Error POST";
}

