<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Pacientes;
use CorePHP\Models\Doctores;
use CorePHP\Models\Estudios;
use CorePHP\Models\Resultados;
                                                        
header('Content-Type: text/html; charset=utf-8');

class DoctoresController
{
  private $_data = null;
  private $_instanceDoctores  = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceDoctores = new Doctores();
      $this->_instancePacientes = new Pacientes();
      $this->_instanceEstudios = new Estudios();
      $this->_instanceResultados = new Resultados();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    $code = "";

    if(isset($stats)) {

      if ($this->_instancePacientes->count() && $this->_instanceDoctores->count() && $this->_instanceEstudios->count() && $this->_instanceResultados->count()) {
        $code = "
        <div class='col s6 m3'>
          <div class='center-align card-panel blue-grey darken-3 grey-text'>
            <span class='flow-text'>Pacientes</span>
            <h2 class='stats primary'>".$this->_instancePacientes->numero."</h2>
          </div>
        </div>
        <div class='col s6 m3'>
          <div class='center-align card-panel blue-grey darken-3 grey-text'>
            <span class='flow-text'>Doctores </span>
            <h2 class='stats primary'>".$this->_instanceDoctores->numero."</h2>
          </div>
        </div>
        <div class='col s6 m3'>
          <div class='center-align card-panel blue-grey darken-3 grey-text'>
            <span class='flow-text'>Estudios</span>
            <h2 class='stats primary'>".$this->_instanceEstudios->numero."</h2>
          </div>
        </div>
        <div class='col s6 m3'>
          <div class='center-align card-panel blue-grey darken-3 grey-text'>
            <span class='flow-text'>Resultados</span>
            <h2 class='stats primary'>".$this->_instanceResultados->numero."</h2>
          </div>
        </div>
        ";
      }

      echo $code;
    }
    else {
      echo "Error: Solicitud invalida";
    }
  }
}
if($_POST){
  new DoctoresController($_POST);
}else{
  echo "Error POST";
}

