<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Estudios;
use CorePHP\Models\Categorias_Estudios;
                                                        
header('Content-Type: text/html; charset=utf-8');

class EstudiosController
{
  private $_data = null;
  private $_instanceEstudios  = null;
  private $_instanceCategoria = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceEstudios = new Estudios();
      $this->_instanceCategoria = new Categorias_Estudios();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    $code = ""; 

    if (isset($busca_estudio)) {
      
      if ($busca_estudio != "") {
        
        $estudios = $this->_instanceEstudios->getItemSearch($busca_estudio);

        if (count($estudios)) {
          
          foreach ($estudios as $estudio) {

            $id = $estudio->clave;

            $code .= "
              <li class='elements-inline'>";

            if($estudio->disponibilidad == '1'){
              $code .= "<i id='block-disp' class='material-icons right'>lock</i>";
            }
            else {
              $code .= "<i id='unblock-disp' class='material-icons right'>lock_open</i>";
            }
            $code .= "
                <i id='editEstudios' class='material-icons right'>edit</i>
                <span id='control'>$estudio->clave</span>
                <span val='$estudio->id_Estudio' id='nombre-estudio'>$estudio->estudio</span>
              </li>
            ";
          }

          echo $code;
        }
        else {
          echo "
            <li class='elements-inline'>
              <h5>No se encontraron resultados</h5>
            </li>
          ";
        }
      }

    }
    else if (isset($block)){
      if ($block != "") {
        $this->_instanceEstudios->blockItem($block);
      }
      else {
        echo "Parámetro vacios";
      }
    }
    else if (isset($unblock)){
      if ($unblock != "") {
        $this->_instanceEstudios->unblockItem($unblock);
      }
      else {
        echo "Parámetro vacios";
      }
    }
    else if(isset($item)){
      if ($item != "") {
        
        $this->_instanceEstudios->getItem($item);

        header('Content-Type: application/json');
        
        echo "{
            \"id\": \"".$this->_instanceEstudios->id_Estudio."\",
            \"clave\": \"".$this->_instanceEstudios->clave."\",
            \"estudio\": \"".$this->_instanceEstudios->estudio."\",
            \"categoria\": \"".$this->_instanceEstudios->categoria."\",
            \"entrega\": \"".$this->_instanceEstudios->entrega."\",
            \"precio\": \"".$this->_instanceEstudios->precio."\",
            \"preparacion\": \"".$this->_instanceEstudios->preparacion."\"
          }";
      }
    }
    else if(isset($estudio_nuevo_clave)  && isset($estudio_nuevo_categoria)  && isset($estudio_nuevo_estudio)  && isset($estudio_nuevo_entrega)  && isset($estudio_nuevo_precio)  && isset($estudio_nuevo_indicaciones)){

      if($estudio_nuevo_clave != ""  && $estudio_nuevo_categoria != ""  && $estudio_nuevo_estudio != ""  && $estudio_nuevo_entrega != ""  && $estudio_nuevo_precio != ""  && $estudio_nuevo_indicaciones != "") {

        $item = array(
          "clave" => $estudio_nuevo_clave,
          "estudio" => $estudio_nuevo_estudio,
          "categoria" => $estudio_nuevo_categoria,
          "entrega" => $estudio_nuevo_entrega,
          "precio" => $estudio_nuevo_precio,
          "preparacion" => $estudio_nuevo_indicaciones,
        );

        $this->_instanceEstudios->insertItem($item);

        echo "Estudio agregado a la base";
      }
      else {
          echo "Error: Campos Vacios";
      }
    }

    else if ( isset($estudio_edit_clave) && isset($estudio_edit_categoria) && isset($estudio_edit_estudio) && isset($estudio_edit_entrega) && isset($estudio_edit_precio) && isset($estudio_edit_indicaciones) && isset($estudio_editar_reg) ){

      if ( $estudio_edit_clave != "" && $estudio_edit_categoria != "" && $estudio_edit_estudio != "" && $estudio_edit_entrega != "" && $estudio_edit_precio != "" && $estudio_edit_indicaciones != "" && $estudio_editar_reg != "" ) {
        
        $item = array(
          "clave" => $estudio_edit_clave,
          "categoria" => $estudio_edit_categoria,
          "estudio" => $estudio_edit_estudio,
          "entrega" => $estudio_edit_entrega,
          "precio" => $estudio_edit_precio,
          "preparacion" => $estudio_edit_indicaciones
          );

        $this->_instanceEstudios->updateItem($estudio_editar_reg, $item);

        echo "Estudio actualizado correctamente";

      }
    }

    else if (isset($estudio_categoria_nueva)) {
      if ($estudio_categoria_nueva != "") {
        
        $item = array('categoria' => $estudio_categoria_nueva);
        
        $this->_instanceCategoria->insertItem($item);

        echo "Se agregó $estudio_categoria_nueva a la base";
      }
    }

    else if (isset($estudio_nuevo_categoria)) {

        $categorias = $this->_instanceEstudios->getAllCategorias();

        foreach ($categorias as $categoria) {

          $code .= "<option value='$categoria->id_Categoria_Estudio'>$categoria->categoria</option>";
        }

        echo $code;
    }

    else if (isset($edit_categoria_input) && isset($edit_categoria_id)) {

      if ($edit_categoria_input != "" && $edit_categoria_id != "") {

        $ups = array('categoria' => $edit_categoria_input );

        $this->_instanceCategoria->updateItem($edit_categoria_id,$ups);
        
        echo "Categoría actualizada correctamente";


      }
    }
    else if (isset($delete_categoria_confirm)) {
      $this->_instanceCategoria->deleteItem($delete_categoria_confirm);

      echo "Categoría elminiada correctamente";
    }
    else if (isset($lista_categorias)) {

        $categorias = $this->_instanceEstudios->getAllCategorias();

        foreach ($categorias as $categoria) {

          $this->_instanceEstudios->relEsp($categoria->id_Categoria_Estudio);
          $code .= "
            <li class='elements-inline'>";
              if (!$this->_instanceEstudios->posible) {
                $code .= "<i class='material-icons right' id='categoria-delete-item'>delete</i>";
              }
              $code .= "<i class='material-icons right' id='categoria-edit-item'>edit</i>
              <span val='$categoria->id_Categoria_Estudio' id='nombre-categoria'>".$categoria->categoria."</span>
            </li>
          ";
        }

        echo $code;
    }

    else {
      echo "Error: Solicitud Invalida";
    }
  }
}
if($_POST){
  new EstudiosController($_POST);
}else{
  echo "Error POST";
}

