<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Especialidades;
use CorePHP\Models\Doctores;
                                                        
header('Content-Type: text/html; charset=utf-8');

class EspecialidadesController
{
  private $_data = null;
  private $_instanceEspecialidades  = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceEspecialidades = new Especialidades();
      $this->_instanceDoctores = new Doctores();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    $code = "";

    if(isset($especialidad_nueva)) {

      if ($especialidad_nueva != "") {

        $item = array('especialidad' => $especialidad_nueva);

        $this->_instanceEspecialidades->insertItem($item);

        echo "Se agregó $especialidad_nueva a la base";
      }
      else {
        echo "Parametros vacios";
      }
      
    }
    else if(isset($list)) {

      $especialides = $this->_instanceEspecialidades->getAllItems();

      if(count($especialides)) {

        foreach ($especialides as $especialidad) {

          $this->_instanceDoctores->relEsp($especialidad->id_Especialidad);

          $code .= "
            <li class='elements-inline'>";
              if (!$this->_instanceDoctores->posible) {
                $code .= "<i class='material-icons right' id='especialidad-delete-item'>delete</i>";
              }
              $code .= "<i class='material-icons right' id='especialidad-edit-item'>edit</i>
              <span val='$especialidad->id_Especialidad' id='nombre-especialidad'>".$especialidad->especialidad."</span>
            </li>
          ";
        }

        echo $code;
      }
    }
    else if(isset($select)) {

      $especialides = $this->_instanceEspecialidades->getAllItems();

      if(count($especialides)) {

        foreach ($especialides as $especialidad) {
          $code .= "
            <option value='$especialidad->id_Especialidad'>$especialidad->especialidad</option>
          ";
        }

        echo $code;
      }
    }
    else if (isset($edit_espec_input) && isset($edit_espec_id)) {

      if ($edit_espec_input != "" && $edit_espec_id != "") {

        $ups = array('especialidad' => $edit_espec_input);

        $this->_instanceEspecialidades->updateItem($edit_espec_id,$ups);
        
        echo "Especialidad actualizada correctamente";


      }
    }
    else if (isset($delete_espec_confirm)) {
      $this->_instanceEspecialidades->deleteItem($delete_espec_confirm);

      echo "Especialidad elminiada correctamente";
    }
    else {
      echo "Error: Solicitud invalida";
    }
  }
}
if($_POST){
  new EspecialidadesController($_POST);
}else{
  echo "Error POST";
}

