<?php
namespace Controllers;

require_once __DIR__."/../../vendor/autoload.php";

use CorePHP\Models\Doctores;
                                                        
header('Content-Type: text/html; charset=utf-8');

class DoctoresController
{
  private $_data = null;
  private $_instanceDoctores  = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceDoctores = new Doctores();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    $code = ""; 

    if (isset($busca_doctor)) {
      
      if ($busca_doctor != "") {
        
        $doctores = $this->_instanceDoctores->getItemSearch($busca_doctor);

        if (count($doctores)) {
          
          foreach ($doctores as $doctor) {

            $id = $doctor->clave;

            $code .= "
              <li class='elements-inline'>
                
                <i class='material-icons right' id='info-sesion'>lock</i>
                <i class='material-icons right' id='edit-doctor-pen'>edit</i>
                
                <span id='control' val='$doctor->id_Doctor'>$doctor->clave</span>
                <span id='nombre' data-app='$doctor->app'>". $doctor->nombre ."</span>
              </li>
            ";
          }

          echo $code;
        }
        else {
          echo "
            <li class='elements-inline'>
              <h5>No se encontraron resultados</h5>
            </li>
          ";
        }
      }

    }
    else if(isset($edit_doctor)) {

      $this->_instanceDoctores->getItem($edit_doctor);

      header('Content-Type: application/json');

      echo "{
        \"id\": \"" . $this->_instanceDoctores->id_Doctor . "\",
        \"nombre\": \"" . $this->_instanceDoctores->nombre . "\",
        \"apellido_paterno\": \"" . $this->_instanceDoctores->apellido_paterno . "\",
        \"apellido_materno\": \"" . $this->_instanceDoctores->apellido_materno . "\",
        \"especialidad\": \"" . $this->_instanceDoctores->especialidad . "\",
        \"telefono\": \"" . $this->_instanceDoctores->telefono . "\",
        \"correo\": \"" . $this->_instanceDoctores->correo . "\",
        \"clave\": \"" . $this->_instanceDoctores->clave . "\"
      }";
    }
    else if(isset($doctor_nuevo_expediente)  && isset($doctor_nuevo_nombre)  && isset($doctor_nuevo_apellidop)  && isset($doctor_nuevo_apellidom)  && isset($doctor_nuevo_especialidad)  && isset($doctor_nuevo_telefono)  && isset($doctor_nuevo_email)) {

      if($doctor_nuevo_expediente != ""  && $doctor_nuevo_nombre != ""  && $doctor_nuevo_apellidop != ""  && $doctor_nuevo_especialidad != ""  && $doctor_nuevo_telefono != ""  && $doctor_nuevo_email != "") {

        $item = array(
          "nombre" => $doctor_nuevo_nombre,
          "apellido_paterno" => $doctor_nuevo_apellidop,
          "apellido_materno" =>  $doctor_nuevo_apellidom,
          "especialidad" => $doctor_nuevo_especialidad,
          "telefono" => $doctor_nuevo_telefono,
          "correo" => $doctor_nuevo_email,
          "clave" => $doctor_nuevo_expediente
        );

        $this->_instanceDoctores->insertItem($item);

        echo "Doctor agregado a la base";
      }
      else {
          echo "Error: Campos Vacios";
      }
    }
    else if(isset($id_doctor_editar_app) &&isset($doctor_editar_expediente) &&isset($doctor_editar_nombre) &&isset($doctor_editar_apellidop) &&isset($doctor_editar_apellidom) &&isset($doctor_editar_especialidad) &&isset($doctor_editar_telefono) &&isset($doctor_editar_email)) {

      if ($id_doctor_editar_app != "" &&$doctor_editar_expediente != "" &&$doctor_editar_nombre != "" &&$doctor_editar_apellidop != "" &&$doctor_editar_apellidom != "" &&$doctor_editar_especialidad != "" &&$doctor_editar_telefono != "" &&$doctor_editar_email != "") {

        $item = array(
          "nombre" => $doctor_editar_nombre,
          "apellido_paterno" => $doctor_editar_apellidop,
          "apellido_materno" =>  $doctor_editar_apellidom,
          "especialidad" => $doctor_editar_especialidad,
          "telefono" => $doctor_editar_telefono,
          "correo" => $doctor_editar_email,
          "clave" => $doctor_editar_expediente
        );
        
        $this->_instanceDoctores->updateItem($id_doctor_editar_app,$item);

        echo "Datos del doctor actualizados correctamente";
      }
    }
    else {
      echo "Error: Solicitud Invalida";
    }
  }
}
if($_POST){
  new DoctoresController($_POST);
}else{
  echo "Error POST";
}

