<?php

namespace CorePHP\Models;



use CorePHP\Core\Conexion;
use CorePHP\Core\Utils\Validations;
use CorePHP\Core\Collections\Collection;
use CorePHP\Core\Libraries\ModelDefinition;
use CorePHP\Libraries\QueryMap;

class Resultados extends ModelDefinition {

    public $id_Resultado;
	public $paciente;
	public $fecha;
	public $estudio;
	public $estatus;
	public $doctor;

    public function __construct(Conexion &$conx = null)
    {
        $this->id_Resultado = null;
		$this->paciente = null;
		$this->fecha = null;
		$this->estudio = null;
		$this->estatus = null;
		$this->doctor = null;

        $this->initConexion($conx);
    }

    /**
     * Inizializa la conexion del modelo
     * 
     * @param Conexion $conx
     * @throws \Exception
     * @return mixed
     */
    protected function initConexion(&$conx)
    {
        if(empty($conx)){
            try{
                $this->conx = new Conexion();
            }catch(\Exception $e){
                throw new \Exception($e);
            }

        }else{
            $this->conx = $conx;
        }

        $this->query = new QueryMap();
        $this->query->ResultadosQuery();
    }

    public function count()
    {
        $query = $this->query->queryList['Resultados']['count'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    public function cambiaEstatus(array $data)
    {
        $fields = [['estatus','numeric'],['id','numeric']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            
            $query = $this->query->queryList['Resultados']['cambiaEstatus'];
            
            $insert = array(
                "[[estatus]]" => $data['estatus'],
                "[[id]]" => $data['id']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }
    /**
     * Busca y carga un elemento basado en su ID
     * 
     * @param int $id
     * @throws \Exception
     * @return bool
     */
    public function getItem($id)
    {
        $query = $this->query->queryList['Resultados']['getItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    public function getFiles($id)
    {
        $query = $this->query->queryList['Resultados']['getFiles'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    /**
     * Carga la totalidad de elemtnos y los devuelve como una clase Collection
     * 
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Resultados >
     */
    public function getAllItems()
    {
        $query = $this->query->queryList['Resultados']['getAllItems'];

        $this->conx->initializeQuery($query);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    public function getList()
    {
        $query = $this->query->queryList['Resultados']['getList'];

        $this->conx->initializeQuery($query);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    public function getHistorial()
    {
        $query = $this->query->queryList['Resultados']['getHistorial'];

        $this->conx->initializeQuery($query);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Carga la totalidad de elementos y los devuelve en una variable de tipo Collection
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Resultados >
     */
    public function getAllItemsByDoctor($id)
    {
        $query = $this->query->queryList['Resultados']['getAllItemsByDoctor'];
        $insert = [
            "[[id]]" => $id
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }


/**
     * Carga la totalidad de elementos y los devuelve en una variable de tipo Collection
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Resultados >
     */
    public function getAllItemsByEstatus($id)
    {
        $query = $this->query->queryList['Resultados']['getAllItemsByEstatus'];
        $insert = [
            "[[id]]" => $id
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }


/**
     * Carga la totalidad de elementos y los devuelve en una variable de tipo Collection
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Resultados >
     */
    public function getAllItemsByEstudio($id)
    {
        $query = $this->query->queryList['Resultados']['getAllItemsByEstudio'];
        $insert = [
            "[[id]]" => $id
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }


/**
     * Carga la totalidad de elementos y los devuelve en una variable de tipo Collection
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Resultados >
     */
    public function getAllItemsByPaciente($id)
    {
        $query = $this->query->queryList['Resultados']['getAllItemsByPaciente'];
        $insert = [
            "[[id]]" => $id
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Resultados($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }




    /**
     * Agrega un nuevo elemento a la tabla designada por el modelo
     * 
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function insertItem(array $data)
    {
        $fields = [['paciente','numeric'],['estudio','numeric'],['estatus','numeric'],['doctor','numeric']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            $query = $this->query->queryList['Resultados']['insertItem'];
            $insert = array(
                "[[id_Resultado]]" => $data['id_Resultado'],
				"[[paciente]]" => $data['paciente'],
				"[[fecha]]" => $data['fecha'],
				"[[estudio]]" => $data['estudio'],
				"[[estatus]]" => $data['estatus'],
				"[[doctor]]" => $data['doctor']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }

    public function assignPDF(array $data)
    {
        $fields = [['id','string'],['pdf','string']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            $query = $this->query->queryList['Resultados']['insertPDF'];
            $insert = array(
                "[[pdf]]" => $data['pdf'],
                "[[id]]" => $data['id']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }

    public function assignJPG(array $data)
    {
        $fields = [['id','string'],['jpg','string']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            $query = $this->query->queryList['Resultados']['insertJPG'];
            $insert = array(
                "[[jpg]]" => $data['jpg'],
                "[[id]]" => $data['id']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }

     public function insertItemAssignation(array $data)
    {
        $fields = [['paciente','numeric'],['estudio','numeric'],['doctor','numeric'],['fecha','string']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
          
          $query = $this->query->queryList['Resultados']['insertItemAssignation'];
          
          $insert = array(
            "[[paciente]]" => $data['paciente'],
            "[[estudio]]" => $data['estudio'],
            "[[estatus]]" => 2,
            "[[doctor]]" => $data['doctor'],
            "[[fecha]]" => $data['fecha']
          );

          $this->conx->initializeQuery($query, $insert);
          try{
              $this->conx->setRequest();
          }catch(\Exception $e){
              throw new \Exception($e);
          }
        }else{
            throw new \Exception($val[1]);
        }
    }
    /**
     * Actualiza la informacion y campos especificados por $data en el elemnto con identificador $id
     * 
     * @param int $id
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function updateItem($id, array $data)
    {
        $query = $this->query->queryList['Resultados']['updateItem'];
        $replace = "";

        if(empty($data)){
            throw new \Exception("Informacion de actualizacion invalida.");
        }

        foreach($data as $key => $value){
            if($replace == ""){
                $replace .= is_numeric($value) ? "$key = $value" : "$key = '$value'";
            }else{
                $replace .= is_numeric($value) ? ", $key = $value" : ", $key = '$value'";
            }
        }

        $query = str_replace("[[data]]",$replace,$query);
        $update = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $update);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Elimina un elemento con identificador $id de la tabla especificada en el modelo
     * 
     * @param int $id
     * @throws \Exception
     * @return mixed
     */
    public function deleteItem($id)
    {
        $query = $this->query->queryList['Resultados']['deleteItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Retorna un objeto de tipo Resultados con el ultimo registro disponible
     * 
     * @throws \Exception
     * @return \CorePHP\Models\Resultados
     */
    public function getLastItem()
    {
        $query = $this->query->queryList['Resultados']['getLastItem'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    public function getPDF($id)
    {
        $query = $this->query->queryList['Resultados']['getPDF'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    public function getJPG($id)
    {
        $query = $this->query->queryList['Resultados']['getJPG'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }
}
