<?php

namespace CorePHP\Models;



use CorePHP\Core\Conexion;
use CorePHP\Core\Utils\Validations;
use CorePHP\Core\Collections\Collection;
use CorePHP\Core\Libraries\ModelDefinition;
use CorePHP\Libraries\QueryMap;

class Pacientes extends ModelDefinition {

    public $id_Paciente;
	public $nombre;
	public $apellido_paterno;
	public $apellido_materno;
	public $fecha_nacimiento;
	public $expediente;

    public function __construct(Conexion &$conx = null)
    {
        $this->id_Paciente = null;
		$this->nombre = null;
		$this->apellido_paterno = null;
		$this->apellido_materno = null;
		$this->fecha_nacimiento = null;
		$this->expediente = null;

        $this->initConexion($conx);
    }

    /**
     * Inizializa la conexion del modelo
     * 
     * @param Conexion $conx
     * @throws \Exception
     * @return mixed
     */
    protected function initConexion(&$conx)
    {
        if(empty($conx)){
            try{
                $this->conx = new Conexion();
            }catch(\Exception $e){
                throw new \Exception($e);
            }

        }else{
            $this->conx = $conx;
        }

        $this->query = new QueryMap();
        $this->query->PacientesQuery();
    }

    public function count()
    {
        $query = $this->query->queryList['Pacientes']['count'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    public function getItemSearch($search)
    {
        $query = $this->query->queryList['Pacientes']['getItemSearch'];
        $insert = [
            "[[search]]" => $search
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Pacientes($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Busca y carga un elemento basado en su ID
     * 
     * @param int $id
     * @throws \Exception
     * @return bool
     */
    public function getItem($id)
    {
        $query = $this->query->queryList['Pacientes']['getItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    public function getItemById($id)
    {
        $query = $this->query->queryList['Pacientes']['getItemById'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }


    public function login($user, $pass)
    {
        $query = $this->query->queryList['Pacientes']['login'];
        $data = array(
            "[[user]]" => $user,
            "[[pass]]" => $pass
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }
    

    /**
     * Carga la totalidad de elemtnos y los devuelve como una clase Collection
     * 
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Pacientes >
     */
    public function getAllItems()
    {
        $query = $this->query->queryList['Pacientes']['getAllItems'];

        $this->conx->initializeQuery($query);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Pacientes($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    

    /**
     * Agrega un nuevo elemento a la tabla designada por el modelo
     * 
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function insertItem(array $data)
    {
        $fields = [['nombre','string'],['apellido_paterno','string'],['apellido_materno','string'],['fecha_nacimiento','string'],['expediente','numeric']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            $query = $this->query->queryList['Pacientes']['insertItem'];
            $insert = array(
                "[[nombre]]" => $data['nombre'],
				"[[apellido_paterno]]" => $data['apellido_paterno'],
				"[[apellido_materno]]" => $data['apellido_materno'],
				"[[fecha_nacimiento]]" => $data['fecha_nacimiento'],
				"[[expediente]]" => $data['expediente']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }

    /**
     * Actualiza la informacion y campos especificados por $data en el elemnto con identificador $id
     * 
     * @param int $id
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function updateItem($id, array $data)
    {
        $query = $this->query->queryList['Pacientes']['updateItem'];
        $replace = "";

        if(empty($data)){
            throw new \Exception("Informacion de actualizacion invalida.");
        }

        foreach($data as $key => $value){
            if($replace == ""){
                $replace .= is_numeric($value) ? "$key = $value" : "$key = '$value'";
            }else{
                $replace .= is_numeric($value) ? ", $key = $value" : ", $key = '$value'";
            }
        }

        $query = str_replace("[[data]]",$replace,$query);
        $update = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $update);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Elimina un elemento con identificador $id de la tabla especificada en el modelo
     * 
     * @param int $id
     * @throws \Exception
     * @return mixed
     */
    public function deleteItem($id)
    {
        $query = $this->query->queryList['Pacientes']['deleteItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Retorna un objeto de tipo Pacientes con el ultimo registro disponible
     * 
     * @throws \Exception
     * @return \CorePHP\Models\Pacientes
     */
    public function getLastItem()
    {
        $query = $this->query->queryList['Pacientes']['getLastItem'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

}
