<?php

namespace CorePHP\Models;



use CorePHP\Core\Conexion;
use CorePHP\Core\Utils\Validations;
use CorePHP\Core\Collections\Collection;
use CorePHP\Core\Libraries\ModelDefinition;
use CorePHP\Libraries\QueryMap;

class Estudios extends ModelDefinition {

    public $id_Estudio;
	public $clave;
	public $estudio;
	public $categoria;
	public $entrega;
	public $precio;
	public $preparacion;

    public function __construct(Conexion &$conx = null)
    {
        $this->id_Estudio = null;
		$this->clave = null;
		$this->estudio = null;
		$this->categoria = null;
		$this->entrega = null;
		$this->precio = null;
		$this->preparacion = null;

        $this->initConexion($conx);
    }

    /**
     * Inizializa la conexion del modelo
     * 
     * @param Conexion $conx
     * @throws \Exception
     * @return mixed
     */
    protected function initConexion(&$conx)
    {
        if(empty($conx)){
            try{
                $this->conx = new Conexion();
            }catch(\Exception $e){
                throw new \Exception($e);
            }

        }else{
            $this->conx = $conx;
        }

        $this->query = new QueryMap();
        $this->query->EstudiosQuery();
    }

    public function getItemById($id)
    {
        $query = $this->query->queryList['Estudios']['getItemById'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    public function getItemSearch($search)
    {
        $query = $this->query->queryList['Estudios']['getItemSearch'];
        $insert = [
            "[[search]]" => $search
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Estudios($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Busca y carga un elemento basado en su ID
     * 
     * @param int $id
     * @throws \Exception
     * @return bool
     */
    public function getItem($id)
    {
        $query = $this->query->queryList['Estudios']['getItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    public function count()
    {
        $query = $this->query->queryList['Estudios']['count'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    public function getAllCategorias()
    {
        $query = $this->query->queryList['Estudios']['getAllCategorias'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Estudios($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /*
      Desbloquea un estudio, de forma que en el listado de estudios de la página web la disponinibilidad cambie a disponible
    */
    public function unblockItem($id)
    {
      $query = $this->query->queryList['Estudios']['unblock'];
      $data = array(
          "[[id]]" => $id
      );

      $this->conx->initializeQuery($query, $data);
      
      try{
        $this->conx->setRequest();
      }catch(\Exception $e){
          throw new \Exception($e);
      }
    }


    /*
      Bloquea un estudio, de forma que en el listado de estudios de la página web la disponinibilidad cambie a no disponible
    */
    public function blockItem($id)
    {
      $query = $this->query->queryList['Estudios']['block'];
      $data = array(
          "[[id]]" => $id
      );

      $this->conx->initializeQuery($query, $data);

      try{
        $this->conx->setRequest();
      }catch(\Exception $e){
          throw new \Exception($e);
      }
    }

    /*
      Verifica si el estudio está asignado a una Categoria para poder validar si la categoría puede o no ser borrada
    */
    public function relEsp($id)
    {
        $query = $this->query->queryList['Estudios']['relEsp'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    /**
     * Carga la totalidad de elemtnos y los devuelve como una clase Collection
     * 
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Estudios >
     */
    public function getAllItems()
    {
        $query = $this->query->queryList['Estudios']['getAllItems'];

        $this->conx->initializeQuery($query);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Estudios($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Carga la totalidad de elementos y los devuelve en una variable de tipo Collection
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Estudios >
     */
    public function getAllItemsByCategoria($id)
    {
        $query = $this->query->queryList['Estudios']['getAllItemsByCategoria'];
        $insert = [
            "[[id]]" => $id
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Estudios($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Función para buscadores dentro de la página
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Estudios >
     */
    public function getAllItemsByLike($comp)
    {
        $query = $this->query->queryList['Estudios']['getAllItemsByLike'];
        $insert = [
            "[[comp]]" => $comp
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Estudios($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Función para buscadores dentro de la página
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Estudios >
     */
    public function getAllItemsByCat($comp)
    {
        $query = $this->query->queryList['Estudios']['getAllItemsByCat'];
        $insert = [
            "[[cat]]" => $comp
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Estudios($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }


    /**
     * Agrega un nuevo elemento a la tabla designada por el modelo
     * 
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function insertItem(array $data)
    {
        $fields = [['clave','string'],['estudio','string'],['categoria','numeric'],['entrega','string'],['precio','string'],['preparacion','string']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            $query = $this->query->queryList['Estudios']['insertItem'];
            $insert = array(
                "[[clave]]" => $data['clave'],
				"[[estudio]]" => $data['estudio'],
				"[[categoria]]" => $data['categoria'],
				"[[entrega]]" => $data['entrega'],
				"[[precio]]" => $data['precio'],
				"[[preparacion]]" => $data['preparacion']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }

    /**
     * Actualiza la informacion y campos especificados por $data en el elemnto con identificador $id
     * 
     * @param int $id
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function updateItem($id, array $data)
    {
        $query = $this->query->queryList['Estudios']['updateItem'];
        $replace = "";

        if(empty($data)){
            throw new \Exception("Informacion de actualizacion invalida.");
        }

        foreach($data as $key => $value){
            if($replace == ""){
                $replace .= is_numeric($value) ? "$key = $value" : "$key = '$value'";
            }else{
                $replace .= is_numeric($value) ? ", $key = $value" : ", $key = '$value'";
            }
        }

        $query = str_replace("[[data]]",$replace,$query);
        $update = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $update);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Elimina un elemento con identificador $id de la tabla especificada en el modelo
     * 
     * @param int $id
     * @throws \Exception
     * @return mixed
     */
    public function deleteItem($id)
    {
        $query = $this->query->queryList['Estudios']['deleteItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Retorna un objeto de tipo Estudios con el ultimo registro disponible
     * 
     * @throws \Exception
     * @return \CorePHP\Models\Estudios
     */
    public function getLastItem()
    {
        $query = $this->query->queryList['Estudios']['getLastItem'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

}
