<?php

namespace CorePHP\Models;

use CorePHP\Core\Libraries\AdminDefinition;

use CorePHP\Core\Conexion;
use CorePHP\Core\Utils\Validations;
use CorePHP\Core\Collections\Collection;
use CorePHP\Core\Libraries\ModelDefinition;
use CorePHP\Libraries\QueryMap;

class Administradores extends ModelDefinition implements AdminDefinition{

    public $id_Administrador;
	public $nombre;
	public $apellidos;
	public $usuario;
	public $contraseña;
	public $tipo;

    public function __construct(Conexion &$conx = null)
    {
        $this->id_Administrador = null;
		$this->nombre = null;
		$this->apellidos = null;
		$this->usuario = null;
		$this->contraseña = null;
		$this->tipo = null;

        $this->initConexion($conx);
    }

    /**
     * Inizializa la conexion del modelo
     * 
     * @param Conexion $conx
     * @throws \Exception
     * @return mixed
     */
    protected function initConexion(&$conx)
    {
        if(empty($conx)){
            try{
                $this->conx = new Conexion();
            }catch(\Exception $e){
                throw new \Exception($e);
            }

        }else{
            $this->conx = $conx;
        }

        $this->query = new QueryMap();
        $this->query->AdministradoresQuery();
    }

    public function auth($user, $username){
      $query = $this->query->queryList['Administradores']['auth'];
      $data = array(
          "[[user]]" => $user,
          "[[username]]" => md5($username)
      );

      $this->conx->initializeQuery($query, $data);
      try{
          $result = $this->conx->getRequest();
      }catch(\Exception $e){
          throw new \Exception($e);
      }

      if($result = $result->fetch_assoc()){
          self::autoSerialize($this, $result);

          return true;
      }else{
          return false;
      }
    }
    public function login($user, $pass)
    {
        $query = $this->query->queryList['Administradores']['login'];
        $data = array(
            "[[user]]" => $user,
            "[[pass]]" => $pass
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

    /**
     * Busca y carga un elemento basado en su ID
     * 
     * @param int $id
     * @throws \Exception
     * @return bool
     */
    public function getItem($id)
    {
        $query = $this->query->queryList['Administradores']['getItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            self::autoSerialize($this, $result);

            return true;
        }else{
            return false;
        }
    }

        /**
     * Busca un elemento basado en el usuario
     * @param string $user
     * @throws \Exception
     * @return bool
     */
    public function getItemByUser($user)
    {
        $query = $this->query->queryList['Administradores']['getItemByUser'];
        $data = array(
            "[[user]]" => $user
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            foreach($result as $key => $value){
                $this->$key = $value;
            }

            return true;
        }else{
            return false;
        }
    }

    /**
     * Busca un elemento basado en el password, debe de estar declarado como unico en la base de datos
     * de lo contrario podria generar busquedas equibocadas.
     * @param string $pass
     * @throws \Exception
     * @return bool
     */
    public function getItemByPassword($pass)
    {
        $query = $this->query->queryList['Administradores']['getItemByPassword'];
        $data = array(
            "[[password]]" => $pass
        );

        $this->conx->initializeQuery($query, $data);
        try{
            $result = $this->conx->getRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }

        if($result = $result->fetch_assoc()){
            foreach($result as $key => $value){
                $this->$key = $value;
            }

            return true;
        }else{
            return false;
        }
    }

    /**
     * Carga la totalidad de elemtnos y los devuelve como una clase Collection
     * 
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Administradores >
     */
    public function getAllItems()
    {
        $query = $this->query->queryList['Administradores']['getAllItems'];

        $this->conx->initializeQuery($query);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Administradores($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Carga la totalidad de elementos y los devuelve en una variable de tipo Collection
     *
     * @throws \Exception
     * @return \CorePHP\Core\Collections\Collection < Administradores >
     */
    public function getAllItemsByTipo($id)
    {
        $query = $this->query->queryList['Administradores']['getAllItemsByTipo'];
        $insert = [
            "[[id]]" => $id
        ];

        $this->conx->initializeQuery($query,$insert);
        try{
            $result = $this->conx->getRequest();
            
            $array = [];

            while ($row = $result->fetch_assoc()) {
                $aux = new Administradores($this->conx);

                self::autoSerialize($aux, $row);

                $array[] = $aux;
            }

            return new Collection($array);
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }




    /**
     * Agrega un nuevo elemento a la tabla designada por el modelo
     * 
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function insertItem(array $data)
    {
        $fields = [['nombre','string'],['apellidos','string'],['usuario','string'],['contraseña','string'],['tipo','numeric']];

        $val = Validations::validatePost($fields,$data);
        if($val[0]){
            $query = $this->query->queryList['Administradores']['insertItem'];
            $insert = array(
                "[[nombre]]" => $data['nombre'],
				"[[apellidos]]" => $data['apellidos'],
				"[[usuario]]" => $data['usuario'],
				"[[contraseña]]" => $data['contraseña'],
				"[[tipo]]" => $data['tipo']
            );

            $this->conx->initializeQuery($query, $insert);
            try{
                $this->conx->setRequest();
            }catch(\Exception $e){
                throw new \Exception($e);
            }
        }else{
            throw new \Exception($val[1]);
        }
    }

    /**
     * Actualiza la informacion y campos especificados por $data en el elemnto con identificador $id
     * 
     * @param int $id
     * @param array $data
     * @throws \Exception
     * @return mixed
     */
    public function updateItem($id, array $data)
    {
        $query = $this->query->queryList['Administradores']['updateItem'];
        $replace = "";

        if(empty($data)){
            throw new \Exception("Informacion de actualizacion invalida.");
        }

        foreach($data as $key => $value){
            if($replace == ""){
                $replace .= is_numeric($value) ? "$key = $value" : "$key = '$value'";
            }else{
                $replace .= is_numeric($value) ? ", $key = $value" : ", $key = '$value'";
            }
        }

        $query = str_replace("[[data]]",$replace,$query);
        $update = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $update);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Elimina un elemento con identificador $id de la tabla especificada en el modelo
     * 
     * @param int $id
     * @throws \Exception
     * @return mixed
     */
    public function deleteItem($id)
    {
        $query = $this->query->queryList['Administradores']['deleteItem'];
        $data = array(
            "[[id]]" => $id
        );

        $this->conx->initializeQuery($query, $data);

        try{
            $this->conx->setRequest();
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

    /**
     * Retorna un objeto de tipo Administradores con el ultimo registro disponible
     * 
     * @throws \Exception
     * @return \CorePHP\Models\Administradores
     */
    public function getLastItem()
    {
        $query = $this->query->queryList['Administradores']['getLastItem'];

        $this->conx->initializeQuery($query);

        try{
            $result = $this->conx->getRequest();
            $result = $result->fetch_assoc();

            self::autoSerialize($this, $result);

            return $this;
        }catch(\Exception $e){
            throw new \Exception($e);
        }
    }

}
