<!DOCTYPE html>
<html lang="es">
  <?php
  include 'header.php';
  ?>
    <div class="">
      <div class=""><img src=""></div>
    </div>
    <div class="container">
      <div class="section">
        <div class="row">
          <div class="col s12">
            <div class="card-panel teal white-text justify-align">
              <h4>Marcadores Tumorales</h4>
              <span class="justify-align">
                Un marcador tumoral es una sustancia que es producida por el cuerpo en respuesta al cáncer, o es producida por el cáncer sí mismo. Algunos de estos marcadores son específicos a un cáncer, mientras que otros se ven en varios tipos de cáncer. Estos marcadores se utilizan generalmente para evaluar la respuesta del paciente al tratamiento o para monitorear por la recurrencia (si el cáncer regresa después del tratamiento). Hay condiciones no-cancerosas que pueden hacer que los marcadores se eleven, así que éstas deben también ser consideradas al interpretar los resultados de la prueba. Los marcadores tumorales se pueden utilizar conjuntamente con otras pruebas (exploraciones, biopsias, etc.) para ayudar a diagnosticar a un paciente que tenga síntomas sospechosos para el cáncer. Algunos marcadores pueden ayudan a los médicos a determinar el pronóstico y el tratamiento. <br><br>
                A continuación agregamos una  tabla de los marcadores tumorales más utilizados, de los cánceres en los cuales pueden presentarse, de las condiciones no-cancerosas que pueden elevarlos, y de sus valores de referencia.
              </span>
            </div>
          </div>
          <table class="striped responsive-table">
            <thead>
              <tr>
                <th>Marcador Tumoral</th>
                <th>Cánceres asociados con resultados elevados (** indica la asociación más común, si existe una)</th>
                <th>Elevaciones no cancerosas</th>
                <th>Resultados "normales"</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Alfa-fetoproteína (AFP) (marcador en el plasma sanguíneo)</td>
                <td>Cánceres de la célula de germen de los ovarios y testes ** (No-seminomatosos, particularmente embrional y saco de la yema de huevo, cánceres testiculares) algunos cánceres primarios del hígado (hepatocelulares)</td>
                <td>Embarazo (desaparece después de dar a luz), enfermedad del hígado (hepatitis, cirrosis, lesión del hígado tóxica), enfermedad inflamatoria del intestino</td>
                <td>Niveles bajos se presentan en hombres y en mujeres no embarazadas (0-15 IU/ml); generalmente resultados >400 son causados por el cáncer (vida media 4-6 días)</td>
              </tr>
              <tr>
                <td>Gonadotropina Coriónica Beta-Humana (B-HCG) (marcador en el plasma sanguíneo)</td>
                <td>Tumores de la célula de germen enfermedad trofoblastica gestacional</td>
                <td>Embarazo, uso de la mariguana, hipogonadismo (falla testicular), cirrosis, enfermedad inflamatoria del intestino, úlceras duodenales</td>
                <td>En hombres: < 2.5 U/ml en mujeres no embarazadas: < 5.0 U/ml</td>
              </tr>
              <tr>
                <td>Proteínas de Bence-Jones (orina) o inmunoglobulinas monoclonales (sangre)</td>
                <td>Mieloma múltiple** Leucemia linfocítica crónica de macroglobulinemia de Waldenstrom</td>
                <td>Amiloidosis</td>
                <td>Generalmente, un valor de 0.03-0.05 mg/ml es significativo para la enfermedad temprana</td>
              </tr>
              <tr>
                <td>Antígeno del tumor de la vejiga (BTA) (marcador en la orina)</td>
                <td>Cáncer de la vejiga ** Cáncer del riñón o uréteres</td>
                <td>Procedimiento invasor o infección de la vejiga o de la zona urinaria</td>
                <td>Ninguno detectado normalmente</td>
              </tr>
              <tr>
                <td>CA 15-3 (antígeno carbohidrato 15-3) (marcador en el plasma sanguíneo)</td>
                <td>Seno ** (no elevado a menudo en etapas tempranas del cáncer del seno. Pulmón, ovárico, endometrial, vejiga, gastrointestinal</td>
                <td>Enfermedad del hígado (cirrosis, hepatitis), lupus, sarcoidosis, tuberculosis, lesiones no-cancerosas del seno</td>
                <td>< 31 U/ml (los 30% de pacientes tienen un CA 15-3 elevado por 30-90 días después del tratamiento, así que espere 2-3 meses después de comenzar el tratamiento nuevo para comprobarlo)</td>
              </tr>
              <tr>
                <td>CA 19-9 (antígeno carbohidrato 19-9) (marcador en el plasma sanguíneo)</td>
                <td>Páncreas ** y colorectal** hígado, estómago y cánceres del árbol biliar</td>
                <td>Pancreatitis, colitis ulcerativa, enfermedad inflamatoria del intestino, inflamación u obstrucción del conducto biliar</td>
                <td>< 37 U/ml > 120 U/ml son causados generalmente por tumor</td>
              </tr>
              <tr>
                <td>CA 125 (antígeno carbohidrato 125) (marcador en el plasma sanguíneo)s</td>
                <td>Cáncer del ovario ** Seno, colorectal, uterino, cervical, páncreas, hígado, pulmón</td>
                <td>Embarazo, menstruación, endometriosis, quistes ováricos, fibromas, enfermedad inflamatoria de la pelvis, pancreatitis, cirrosis, peritonitis, efusión pleural, después de la cirugía o de la paracentesis</td>
                <td>0-35 U/ml</td>
              </tr>
              <tr>
                <td>CA 27.29 (antígeno carbohidrato 27.29) (marcador en el plasma sanguíneo)</td>
                <td>Seno ** (mejor usado para detectar la recurrencia o metástasis), Cánceres del colon, gástrico, hígado, pulmón, pancreático, ovárico, próstata</td>
                <td>Quistes ováricos, desórdenes del hígado y riñón, problemas no-cancerosos (benignos) del seno</td>
                <td>< 40 U/ml generalmente, niveles > 100 U/ml significan el cáncer (los 30% de pacientes tienen elevado el CA 27.29 por 30-90 días después del tratamiento, así que espere 2-3 meses después de comenzar el tratamiento nuevo para comprobarlo)</td>
              </tr>
              <tr>
                <td>Antígeno carcinoembrionico (CEA) (marcador en el plasma sanguíneo)</td>
                <td>Cánceres Colorectal ** Seno, pulmón, gástrico, pancreático, vejiga, riñón, tiroides, cabeza y cuello, cervical, ováricos, hígado, linfoma, melanoma</td>
                <td>Tabaquismo, pancreatitis, hepatitis, enfermedad inflamatoria del intestino, enfermedad de la úlcera péptica, hipotiroidismo, cirrosis, COPD, obstrucción biliar</td>
                <td>< 2.5 ng/ml en no fumadores, < 5 ng/ml en fumadores, generalmente, > 100 significa el cáncer metastásico</td>
              </tr>
              <tr>
                <td>5-HIAA (ácido acético 5-Hidroxi-Indol) (colección de orina de 24 horas)</td>
                <td>Tumores carcinoides</td>
                <td>Sprue celiaco y tropical, enfermedad de Whipple, dietética: nueces, pacanas, plátanos, aguacates, berenjenas, piñas, ciruelas y tomates; medicaciones: acetaminophen, aspirina y guaifenesin</td>
                <td>Normal 6-10 mg sobre 24 horas</td>
              </tr>
              <tr>
                <td>Deshidrogenase láctico (LDH) (marcador en el plasma sanguíneo)</td>
                <td>Linfoma, melanoma, leucemia aguda, seminoma (tumores de la célula de germen)</td>
                <td>Hepatitis, insuficiencia miocardial (ataque del corazón), derrame cerebral, anemia (perniciosa y talasemia), distrofia muscular, ciertas medicaciones (narcóticos, aspirina, anestésicos, alcohol), daño muscular</td>
                <td>Los valores normales son de 100-333 u/l</td>
              </tr>
              <tr>
                <td>NMP 22 (marcador urinario)</td>
                <td>** Cáncer de la vejiga</td>
                <td>BPH (hipertrofia prostática benigna), prostatitis</td>
                <td>Normal < 10 U/ml</td>
              </tr>
              <tr>
                <td>PAP (fosfatasa ácida prostática) (marcador en el plasma sanguíneo)</td>
                <td>** Cáncer de la próstata de metastásico Mieloma, cáncer del pulmón, sarcoma ontogénico</td>
                <td>Prostatitis, enfermedad de Gaucher, osteoporosis, cirrosis, hiperparatiroidismo, hipertrofia prostática</td>
                <td>Normal: 0.5 a 1.9 u/l</td>
              </tr>
              <tr>
                <td>PSA (antígeno específico de la próstata)</td>
                <td>Próstata</td>
                <td>BPH (hipertrofia prostática benigna), hiperplasia, prostatitis, trauma de la próstata o inflamación prostática nodular</td>
                <td>Normal < 4 ng/ml (vida media 2-3 días)</td>
              </tr>
              <tr>
                <td>Catecolaminas en la orina: VMA (ácido Vanililmandelico) (colección de orina de 24 horas; es un metabolita de la catecolaminas)</td>
                <td>Neuroblastoma ** feocromocitoma, ganglioneuroma, rabdomiosarcoma, PNET</td>
                <td>Ingestión dietética (plátanos, vainilla, té, café, helado, chocolate), medicaciones (tetraciclinas, metilldopa, MAOIs)</td>
                <td>8 - 35 mmols sobre 24 horas</td>
              </tr>
              <tr>
                <td>HVA (ácido homovanilico) (colección de orina de 24 horas; es un metabolita de la catecolaminas)</td>
                <td>** Neuroblastoma</td>
                <td>Iguales que VMA, además: psicosis, depresión mayor, dopamina (una medicación)</td>
                <td>Hasta 40 mmols sobre 24 horas</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
   <?php
   include 'footer.php';
   ?>
  </body>
</html>