var process_controller = process_controller || (function () {

  var controllers = {

    __cotizaciones: "CotizacionesController.php",
    __resultados: "ResultadosController.php",
    __estudios: "EstudiosController.php",
    __servicio: "ServiciosController.php",
    __login: "LoginController.php",
    __categorias: "CategoriasController.php",
    __especialidad: "EspecialidadesController.php",
    __doctores: "DoctoresController.php",
    __index: "IndexController.php",
    __pacientes: "PacientesController.php",
    __mail: "MailController.php",
    __sesion: "SessionController.php",
    __mailer: "../../Controllers/MailController.php",
    __reportes: "ReportesController.php",
    
    ruta: function (id) {

      return this[id];

    }

  }

  var fechaMySQL = function() {
    var aux = new Date();

    result = aux.getFullYear() + "-";

    if (aux.getMonth() + 1 < 10) {
      result += "0";
    }

    result += aux.getMonth() + 1 + "-" + aux.getDate();

    return result;
  }

  var request_body = function (id, campos, action) {

    return {
      to: controllers.ruta('__' + id),
      body: campos,
      action: action
    }

  }

  var request = function (id, dictionary, action) {
    
    if (dictionary instanceof Object) {
      dictionary = processForm(dictionary);
    }
    ajax.send(request_body(id, dictionary, action));

  } 

  var requestFile = function (id, form, action) {
    
    formRequest = new FormData(form);
    
    ajax.sendFile(request_body(id, formRequest, action));

  }
  var processForm = function (form) {
    
    var res = "";

    for (var i = 0; i < form.length; i++) {
      
      input = form[i];

      if (input.localName != "button") {
        
        if (res != "") {
          res += "&";
        }

        res += input.id + "=" + input.value;
        
      } 
    }

    return res;
  }

  var cleanForm = function (form) {
    
    for (var i = 0; i < form.length -1; i++) {
      
      input = form[i];

      input.value = "";

    }

  }

  var processEvents = function (arreglo) {
    
    for (index in arreglo) {

      trigger = arreglo[index];

      if (trigger) {
        if (!trigger.on) {

          switch (trigger.event) {
            case 'search':
              trigger.timer = null;

              trigger.addEventListener('keyup',function (e) {
                this.timer = setTimeout(function () {
                  this.action(e);
                }.bind(this),500);
              });

              trigger.addEventListener('keypress',function (e) {
                if(this.timer != null) {
                  clearTimeout(this.timer);
                }
              });

              break;
            default:
              trigger.addEventListener(trigger.event, trigger.action)
          } 

          trigger.on = true;
        }
      }
    }
  }   

  return {

    request: request,
    processForm: processForm,
    cleanForm: cleanForm,
    processEvents: processEvents,
    requestFile: requestFile,
    fechaMySQL: fechaMySQL
  }

})();