<!DOCTYPE html>
<html lang="es">
<?php

include 'header.php';

?>

  <div class="container">
    <div class="section">
      <div class="row">
        <h2 class="center-align">Formato de derechos A.R.C.O.</h2>
        <p class="flow-text justify-align">
          Imagen Medica Nuclear S.A. de C.V. (“IMEDNUC”), con domicilio en Av. Insurgentes Norte #1894, Col Lindavista C.P. 07300, Ciudad de M&eacute;xico, hace de su conocimiento que de conformidad con lo establecido en el capítulo IV de la Ley Federal de Protección de Datos Personales en Posesión de los Particulares, usted tiene derecho de ejercer en cualquier momento sus derechos de acceso, rectificación, cancelación y oposición de sus datos personales directamente con la empresa (DERECHOS ARCO).
        </p>
      </div>
      <div class="row">
        <div class="col s12 ">
          <div class="row">
            <form class="col s12 m10 push-m1 l8 push-l2" id="mail-arco">
              <div class="row">
                <div class="input-field col s12 m6">
                  <input type="text" id="arco_nombre" class="validate" required>
                  <label for="">Nombre</label>
                </div>
                <div class="input-field col s12 m6">
                  <input type="text" id="arco_apellido" class="validate" required>
                  <label for="">Apellidos</label>
                </div>
              </div>
              <div class="row">
                <div class="input-field col s12 m4">
                  <input type="email" id="arco_correo" class="validate" required>
                  <label for="">Correo</label>
                </div>
                <div class="input-field col s12 m4">
                  <input type="text" id="arco_tel_local" class="validate" required>
                  <label for="">Teléfono Local</label>
                </div>
                <div class="input-field col s12 m4">
                  <input type="text" id="arco_tel_movil" class="validate" required>
                  <label for="">Teléfono Móvil</label>
                </div>
              </div>
              <div class="row">
                <div class="input-field col s12">
                  <input type="text" id="arco_lugar" class="validate" required>
                  <label for="">Lugar</label>
                </div>
              </div>
              <div class="row">
                <div class="input-field col s12 m4">
                  <input type="date" class="datepicker" id="arco_fecha" placeholder="Fecha de solicitud">
                </div>
                <div class="input-field col s12 m4">
                  <select id="arco_solicitud">
                    <option value="" disabled selected>Tipo de solicitud</option>
                    <option value="Acceso">Acceder a datos personales</option>
                    <option value="Rectificacion">Rectificar datos personales</option>
                    <option value="Cancelación">Supresión de datos</option>
                    <option value="Oposición">Oposición al tramaiento de datos</option>
                  </select>
                </div>
                <div class="input-field col s12 m4">
                  <select id="arco_forma_contacto">
                    <option value="" disabled selected>Forma de contacto</option>
                    <option value="telefono">Teléfono</option>
                    <option value="e-mail">Correo electŕonico</option>
                  </select>
                </div>
              </div>
              <div class="row">
                <button class="btn waves-effect waves-light blue lighten-2 right" id="send-mail-arco" data-form="mail-arco">Enviar solicitud</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="section indigo darken-4 scrollspy" id="contacto-section">
    <div class="container grey-text">
      
      <div class="row">
        <div class="col s12 m4 l6">
          <p class="flow-text justify-align">
            Nos interesa conocer su opinión, ponemos a su disposición el siguiente formulario de contacto. <br> <br>Envíenos un correo ó comuníquese a nuestros números. <br> <br> 
            <a href="mailto:informes@medicanuclear.com">informes@medicanuclear.com</a> <br>
            <a href="tel:86633033">(55) 86-63-30-33</a>
          </p>
        </div>
        <div class="col s12 m8 l6">
          <form id="form-email">
            <div class="input-field">
              <input type="text" name="nombre-contacto" id="nombre_contacto" class="validate" required>
              <label for="nombre-contacto" data-error="Dato obligatorio">Nombre</label>
            </div>
             <div class="input-field">
              <input type="email" name="email-contacto" id="email_contacto" class="validate" required>
              <label for="email-contacto" data-error="Email invalido">Correo Electrónico</label>
            </div>
            <div class="input-field">
              <textarea name="comment-contacto" id="comment_contacto" class="materialize-textarea validate" required></textarea>
              <label for="comment-contacto" data-error="Dato obligatorio">Comentario</label>
            </div>
            <div class="input-field right-align">
              <button class="btn blue waves-effect waves-blue waves-light" id="send-mail" data-form="form-email">Enviar</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <footer class="page-footer blue-grey darken-4">
    <div id="map-w-container">
      <div class="container">
        <button class="btn waves-effect waves-light green darken-2 waves-green" id="como-llegar">Cómo llegar</button>
        <a class="btn-floating subir btn-large waves-effect waves-light blue" id="irCielo">
          <i class="material-icons">keyboard_arrow_up</i>
        </a>
      </div>
      <div id="map-wallpaper"></div>
    </div>
    <div class="footer-address">
      <div class="tira-contacto">
        <div class="row">
          <div class="col s12">
            <div class="inline-elements middle white-text padding-text center-align">
              <div class="hide-on-small-only">
                <i class="material-icons small white-text">business</i>
                <span>Av. Insurgentes Norte #1894, Col Lindavista C.P. 07300, Ciudad de M&eacute;xico</span>
                <i class="material-icons small white-text">email</i>
                <span>informes@medicanuclear.com</span>
                <i class="material-icons small white-text">call</i>
                <span><a href="tel:86633033">(55) 86-63-30-33</a></span>
              </div>
              <div class="hide-on-med-and-up">
                <div class="s12">
                  <i class="material-icons small white-text">business</i>
                <span>Av. Insurgentes Norte #1894, Col Lindavista C.P. 07300, Ciudad de M&eacute;xico</span>
                </div>
                <div class="s12">
                  <i class="material-icons small white-text">email</i>
                <span>informes@medicanuclear.com</span>
                </div>
                <div class="s12">
                  <i class="material-icons small white-text">call</i>
                <span><a href="tel:86633033">(55) 86-63-30-33</a></span>
                </div>
              </div>
            </div>
          </div>
        </div>
        </div>
      </div>
    </div>
    <div class="container">
      <div class="row">
        <div class="col m4 s12">
          <a href="index.php">
            <img src="img/Inicio/logomedicanuclear.png" alt="Logo">
          </a>
          <h6 class="white-text">Diagn&oacute;stico con sentido humano</h6>
          <p class="white-text">Horarios: Lunes a Viernes de 8:00 a 17:00 hrs. S&aacute;bado de 7:30 a 13:30 hrs.</p>
          <a href="avisodeprivacidad.php" class="blue-text text-lighten-3">Aviso de Privacidad</a> <br>
          <a href="formatoarco.php" class="blue-text text-lighten-3">Formato ARCO de privacidad de datos personales</a>
        </div>
        <div class="col m4 s12">
          <h5 class="white-text">Secciones</h5>
          <ul>
            <li><a class="white-text" href="index.php">Inicio</a></li>
            <li><a class="white-text" href="diagnostico-con-sentido-humano-medicina-nuclear.php">Nosotros</a></li>
            <li><a class="white-text" href="laboratorio-de-analisis-clinicos-medicina-nuclear.php">Estudios</a></li>
            <li><a class="white-text" href="articulo-de-la-salud-medicina-nuclear.php">Divulgaci&oacute;n M&eacute;dica</a></li>
            <li><a class="white-text" href="estudios-de-laboratorio-resultados.php">Resultados</a></li>
            <li><a class="white-text" href="promociones-laboratorio-de-analisis-clinicos-medicina-nuclear.php">Promociones</a></li>
            <li><a class="white-text" href="#contacto-section">Contacto</a></li>
          </ul>
        </div>
        <div class="row">
        <div class="col m4 s12">
            <h5 class="white-text">Información Médica</h5>
          <ul>
            <li><a class="white-text">Dr. Pablo Antonio Pichardo Romero</a></li>
            <li><a class="white-text">Responsable Sanitario</a></li>
            <li><a class="white-text">Médico Especialista en Medicina Nuclear</a></li>
            <li><a class="white-text">Cédula De especialidad AECEM-24456</a></li>
            <li><a class="white-text">Permiso COFEPRIS en trámite</a></li>

          </ul>
        </div>
        </div>
      </div>
    </div>
    <div class="footer-copyright blue-grey darken-3">
      <div class="container">
      Desarrollado por <a class="orange-text text-lighten-2" href="https://www.distritokreativo.com.mx">Distrito Kreativo</a>
      </div>
    </div>
  </footer>

  <!-- BT FIXED TO TOOLBAR DEFINITION -->
  <div class="fixed-action-btn toolbar">
    <a class="btn-floating btn-large green hoverable">
      <i class="large material-icons">menu</i>
    </a>
    <ul>
      <li class="waves-effect waves-light"><a href="inicio#cotizaciones-section" class="inline-elements middle"><i class="small material-icons">assignment</i>Cotizaciones</a></li>
      <li class="waves-effect waves-light"><a href="resultados" class="inline-elements middle"><i class="small material-icons">publish</i>Conoce tu resultado</a></li>
      <li class="waves-effect waves-light"><a href="#contacto-section" class="inline-elements middle"><i class="small material-icons">contacts</i>Contacto</a></li>
    </ul>
  </div>
  <script>
    $('select').material_select();
      $('.datepicker').pickadate({
      selectMonths: true, // Creates a dropdown to control month
      selectYears: 15 // Creates a dropdown of 15 years to control year
    });
  </script>  
  <script async defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAOYYON3eQIuCsyhb9lt4FIOGLwqt3l2Io&callback=initMap">
  </script>
  </body>
</html>