<?php
namespace Controllers;

require_once __DIR__."/../vendor/autoload.php";

use CorePHP\Models\Categorias_Estudios;
use CorePHP\Models\Estudios;

header('Content-Type: text/html');

/**
* Clase para manejo de Estudios 
* se define el listado de todos los Estudios y permite agregar más
*/
class ServiciosController
{
  private $_data = null;
  private $_instanceCategorias = null;
  private $_instanceEdtudios = null;
  private $_response = array();
  private $_filter = null;

  public function __construct($argument)
  {
    try {
      $this->_data = json_decode($argument);
      $this->_instanceCategorias = new Categorias_Estudios();
      $this->_instanceEstudios = new Estudios();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    $sub_response['id'] = $this->_data->campos[0]->id;

    try {
      $categorias = $this->_instanceCategorias->getAllItems();
      $code = null;
      if(count($categorias)){
        foreach ($categorias as $categoria) {
          $code .= "<option value=".$this->_filter = $categoria->id_Clasificacion_Estudios.">".$categoria->categoria."</option>";
        }
      } else{
        $code = "Error";
      }
      $sub_response['code'] = $code;
    } catch (\Exception $e) {
      
      echo "Init ".$e->getMessage();
      
    }
    print_r($sub_response);
    $this->_response[] = $sub_response;

    $sub_response['id'] = $this->_data->campos[1]->id;

    try {
      $estudios = $this->_instanceEstudios->getAllItems();
      $code = null;
      if(count($estudios)){
        foreach ($estudios as $estudio) {
          if($estudio->categoria == $this->_filter){
            $code .= "<option value=".$estudio->idEstudio.">".$estudio->estudio."</option>";
          }
        }
      } else{
        $code = "Error";
      }
      $sub_response['code'] = $code;
    } catch (\Exception $e) {
      
      echo "Init ".$e->getMessage();
      
    }
    print_r($sub_response);
    $this->_response[] = $sub_response;

    echo json_encode($this->_response);

  }
}
if($_POST){
  new ServiciosController($_POST['json']);
}else{
  echo "Error POST";
}

