<?php
namespace Controllers;

require_once __DIR__."/../vendor/autoload.php";

use CorePHP\Core\MailUtils;

header('Content-Type: text/html');

/**
* Clase para manejo de Estudios 
* se define el listado de todos los Estudios y permite agregar más
*/
class MailController
{
  private $_data = null;
  private $objMail;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->objMail = new MailUtils();
      $this->__init__();
    }
    catch (\Exception $e) {

      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    if (isset($nombre_contacto) && isset($email_contacto) && isset($comment_contacto)) {
      if ($nombre_contacto != "" && $email_contacto != "" && $comment_contacto != "") {
        try {
          $message = null;
          $this->objMail->title = 'Nuevo mensaje desde sitio web';
          $message = "<ul>
          <li>Nombre: $nombre_contacto</li> 
          <li>Correo: $email_contacto</li>
          <li>Mensaje: $comment_contacto</li>
        </ul>";
        $this->objMail->from     = $email_contacto;
        $this->objMail->to       = 'info@medicanuclear.com';
        $this->objMail->message  = $message;
        $this->objMail->is_html  = true;

        if ($this->objMail->sendEmail()) {
          echo "Mensaje enviado";
        }
      } catch (Exception $e) {
        echo $e->getMessage();
      }
    }
  }
  else if ( isset($arco_nombre) && isset($arco_apellido) && isset($arco_correo) && isset($arco_tel_local) && isset($arco_tel_movil) && isset($arco_lugar) && isset($arco_fecha) && isset($arco_solicitud) && isset($arco_forma_contacto) ) {

    if ( $arco_nombre != "" && $arco_apellido != "" && $arco_correo != "" && $arco_tel_local != "" && $arco_tel_movil != "" && $arco_lugar != "" && $arco_fecha != "" && $arco_solicitud != "" && $arco_forma_contacto != "" ) {
      try {
        $message = null;
        $this->objMail->title = 'Nueva solcitud ARCO de privacidad';
        $message = "<ul>
        <li>Nombre: $arco_nombre"." "."$arco_apellido</li> 
        <li>Correo: $arco_correo</li>
        <li>Teléfono Local: $arco_tel_local</li>
        <li>Teléfono Móvil: $arco_tel_movil</li>
        <li>Lugar: $arco_lugar</li>
        <li>Fecha: $arco_fecha</li>
        <li>Tipo de solicitud: $arco_solicitud</li>
        <li>Forma de contacto: $arco_forma_contacto</li>
      </ul>";
      $this->objMail->from     = $arco_correo;
      $this->objMail->to       = 'avisodeprivacidad@medicanuclear.com';
      $this->objMail->message  = $message;
      $this->objMail->is_html  = true;

      if ($this->objMail->sendEmail()) {
        echo "Mensaje enviado";
      }
    } catch (Exception $e) {
      echo $e->getMessage();
    }
  }
}
else if (isset($soporte_asunto) && isset($soporte_mensaje)) {
  if ($soporte_asunto != "" && $soporte_mensaje != "")
  {
    try {
      $message = null;
      $this->objMail->title = 'Solicitud de soporte por Medica Nuclear';
      $message = "<ul>
      <li>Asunto: $soporte_asunto</li> 
      <li>Mensaje: $soporte_mensaje</li>
    </ul>";
    $this->objMail->from     = "informes@medicanuclear.com";
    $this->objMail->to       = 'aaron@meinen.mx';
    $this->reply_to          = 'adrian@meinen.mx';
    $this->objMail->message  = $message;
    $this->objMail->is_html  = true;

    if ($this->objMail->sendEmail()) {
      echo "Mensaje enviado";
    }
  } catch (Exception $e) {
    echo $e->getMessage();
  }
}
}
else { 
  echo "Error: Solicitud Inválida";
}
}
}
if($_POST){
  new MailController($_POST);
}else{
  echo "Error POST";
}

