<?php
namespace Controllers;



require_once __DIR__."/../vendor/autoload.php";

use CorePHP\Models\Pacientes;
use CorePHP\Models\Resultados;
use CorePHP\Models\Doctores;

header('Content-Type: text/html');

/**
* Clase para manejo de Estudios 
* se define el listado de todos los Estudios y permite agregar más
*/
class LoginController
{
  private $_data = null;
  private $_instanceResultados = null;
  private $_instancePacientes = null;
  private $_instanceDoctores = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceResultados = new Resultados();
      $this->_instancePacientes = new Pacientes();
      $this->_instanceDoctores = new Doctores();
      $this->__init__();
    }
    catch (\Exception $e) {

      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    if(isset($user) && isset($pass)){
      if($user != "" && $pass != "") {
        if(preg_match('/DR-/',$user)){
          $user = substr($user, 3, 5);

          if($this->_instanceDoctores->login($user,$pass)){
            $code = "";

            $code .= " 
            <nav class='transparent grey-text'>
              <div class='nav-wrapper'>
                <a href='#!' class='brand-logo'>Resultados</a>
                <ul class='right hide-on-med-and-down'>
                  <li><a href='sass.html'><i class='material-icons left'>person</i>Dr. ".$this->_instanceDoctores->nombre." ".$pass."</a></li>
                </ul>
              </div>
            </nav>
            ";

            $pacientes_dr = $this->_instanceDoctores->getPacientes_Doctor($this->_instanceDoctores->id);

            if (count($pacientes_dr)) {
              $code .= " 
              <div class='row'>
              <div class='col s12'>    
                  <ul class='collapsible' data-collapsible='accordion'>
                    ";
                    foreach ($pacientes_dr as $paciente) {
                      $code .= "
                      <li>
                        <div class='collapsible-header'>".$paciente->nombre." - ".$paciente->estudio." <span class='right'>".$paciente->fecha."</span></div>
                        <div class='collapsible-body'>
                          <div class='row'>";
                            if ($paciente->estatus == '2') {
                              $code .="
                              <div class='col s12 center-align'>
                                <strong> 
                                  Los resultados de este paciente aún no han sido publicados, revise más tarde
                                </strong>
                              </div>
                              ";
                            }
                            else {

                              $code .= "<div class='col s12'>";

                              if( $this->_instanceResultados->getPDF($paciente->id) ){
                                $pdfs = explode(",",$this->_instanceResultados->pdf);

                                foreach ($pdfs as $pdf) {
                                  $code .= "<div class='col s12 m3'><div class='thumbnail'><img src='img/iconos/file-pdf.svg' /><a class='btn waves-effect waves-light green' href='control-panel/resultados/".$pdf."' download='".$pdf.".pdf'>$pdf.pdf</a></div></div>";
                                }
                              }
                              if( $this->_instanceResultados->getJPG($paciente->id) ){
                                $imgs = explode(",",$this->_instanceResultados->img);

                                foreach ($imgs as $img) {
                                  $code .= "<div class='col s12 m3'><div class='thumbnail'><img src='control-panel/resultados/$img' /><a class='btn waves-effect waves-light green' href='control-panel/resultados/".$img."' download='".$img.".jpg'>$img.jpg</a></div></div>";
                                }
                              }
                              $code .= "</div>";
                            }
                            $code .= "
                          </div>
                        </div>
                      </li>
                      ";
                    }
                    $code.= " </ul>
                  </div>
                </div>";
              }
              else {
                $code .= "<div class='row'>
                <div class='column s12'>
                  <p>No tiene pacientes asigandos</p>
                </div>
              </div>
              ";
            }
          }
          else {
            echo "ms:://Usuario y contraseña incorrectos";
          }
        }
        else {
          if ($this->_instancePacientes->login($user, $pass)) {

            $estudios =  $this->_instanceResultados->getAllItemsByPaciente($this->_instancePacientes->id_Paciente);
            if (count($estudios)) {
              $code = "
              <nav class='transparent grey-text'>
                <div class='nav-wrapper'>
                  <a href='#!' class='brand-logo'>Resultados</a>
                  <ul class='right hide-on-med-and-down'>
                    <li><a href='sass.html'><i class='material-icons left'>person</i>".$this->_instancePacientes->nombre."</a></li>
                  </ul>
                </div>
              </nav>
              <div class='row'>
                <div class='column s12'>    
                  <ul class='collapsible' data-collapsible='accordion'>
                    ";
                    foreach ($estudios as $estudio) {
                      $code .= "
                      <li>
                        <div class='collapsible-header'>".$estudio->categoria." - ".$estudio->estudio." <span class='right'>".$estudio->fecha."</span></div>
                        <div class='collapsible-body'>
                          <div class='row'>
                            <div class='col s12'>
                              <p>Descarga los archivos de los resultados de tus estudios, estos resultados estarán disponibles hasta un mes a aprtir de la fehca en que fueron subidos, si deseas consultar tus resultados en fechas posteriores a un mes o tienes cualquier duda acude a las instalaciones de Médica Nucelar</p>
                            </div>
                            <div class='col s12'>";

                              if( $this->_instanceResultados->getPDF($estudio->id) ){

                                if($this->_instanceResultados->pdf != ""){
                                  $pdfs = explode(",",$this->_instanceResultados->pdf);

                                  foreach ($pdfs as $pdf) {
                                    $code .= "<div class='col s12 m3'><div class='thumbnail'><img src='img/iconos/file-pdf.svg' /><a class='btn waves-effect waves-light green' href='control-panel/resultados/".$pdf."' download='".$pdf.".pdf'>$pdf.pdf</a></div></div>";
                                  }
                                }
                              }
                              if( $this->_instanceResultados->getJPG($estudio->id) ){

                                if ($this->_instanceResultados->img != "") {
                                  $imgs = explode(",",$this->_instanceResultados->img);

                                  foreach ($imgs as $img) {
                                    $code .= "<div class='col s12 m3'><div class='thumbnail'><img src='control-panel/resultados/$img' /><a class='btn waves-effect waves-light green' href='control-panel/resultados/".$img."' download='".$img.".jpg'>$img.jpg</a></div></div>";
                                  }
                                }
                              }
                              if($this->_instanceResultados->pdf == "" && $this->_instanceResultados->img == "") {
                                $code .= "
                                <div class='col s12 center-align'>
                                  <strong>
                                    Tus resultados no se han publicado, intenta más tarde
                                  </strong>
                                </div>
                                ";
                              }
                              $code .= "</div>
                            </div>
                          </div>
                        </li>
                        ";
                      }
                      $code.= " </ul>
                    </div>
                  </div>";
                }
                else {
                  $code .= "
                  <div class='row'>
                    <div class='col s12 center-align'>
                      <div class='card-panel red'>
                        <span class='flow-text white-text'>
                          No tienes resultados de estudios asignados, si tienes problemas para visualizar tus resultados comunicate con nosotros <br> 
                          <a class='btn light-blue darken-4 waves-effect waves-light' href='#contacto-section'>Contacto</a>
                        </span>
                      </div>
                    </div>
                  </div>
                  ";
                }
              }
              else {
                echo "Datos de acceso incorrectos";
              }
            }
            echo $code;
          }
          else {
            echo "Error: Campos vacios";
          }
        }
        else {
          echo "Parametros Incorrectos";
        }
      }
    }
    if($_POST){
      new LoginController($_POST);
    }else{
      echo "Error POST";
    }

