<?php
namespace Controllers;

require_once __DIR__."/../vendor/autoload.php";

use CorePHP\Models\Estudios;
                                                        
header('Content-Type: text/html; charset=utf-8');

class EstudiosController
{
  private $_data = null;
  private $_instanceEstudios = null;

  public function __construct($argument)
  {
    try {
      $this->_data = $argument;
      $this->_instanceEstudios = new Estudios();
      $this->__init__();
    }
    catch (\Exception $e) {
      
      echo "Constructor ".$e->getMessage();

    }

  }

  private function __init__()
  {
    extract($this->_data);

    $code = "";

    if (isset($search)) {

      if ($search != "") {

        $estudios = $this->_instanceEstudios->getAllItemsByLike($search);

        if (count($estudios)) {

          $code .= "<div class='white black-text container-alt-slim'>
                      <table class='striped responsive-table'>
                        <thead>
                          <tr>
                              <th data-field='srv'>Estudio</th>
                              <th data-field='precio'>Precio</th>
                              <th data-field='ind'>Indicaciones</th>
                              <th data-filed='disp'>Disponible</th>
                          </tr>
                        </thead>
          
                        <tbody>";

          foreach ($estudios as $estudio) {

            $code .= "
              <tr>
                <td>".$estudio->estudio."</td>
                <td>".$estudio->precio."</td>
                <td>".$estudio->preparacion."</td>
                <td>".$estudio->estatus."</td>
              </tr>
            ";

          }

          $code .= " 
                </tbody>
              </table>
            </div>
          ";

          echo $code;
        }
        else {
          echo "No se encontraron resultados";
        }        
      }
      else {
        echo "Error: Campos vacio";
      }
    }
    else if (isset($estbycat)) {
      
      if ($estbycat != "") {
        
        $estudios = $this->_instanceEstudios->getAllItemsByCat($estbycat);

        if (count($estudios)) {
          
          $code .= "
            <nav>
              <div class='nav-wrapper indigo lighten-1'>
                <a href='#!' class='brand-logo secondary light'>Estudios - ".$estbycat."</a>
                <form class='right'>
                  <div class='input-field'>
                    <input id='search' type='search' required>
                    <label for='search'><i class='material-icons clickable'>search</i></label>
                    <i class='material-icons'>close</i>
                  </div>
                </form>
              </div>
            </nav>
          <div class='white black-text container-alt-slim'>
            <table class='striped responsive-table'>
              <thead>
                <tr>
                    <th data-field='srv'>Estudio</th>
                    <th data-field='precio'>Precio</th>
                    <th data-field='ind'>Indicaciones</th>
                    <th data-filed='disp'>Disponible</th>
                </tr>
              </thead>

              <tbody>
          ";

          foreach ($estudios as $estudio) {

            $code .= "
              <tr>
                <td>".$estudio->estudio."</td>
                <td>".$estudio->precio."</td>
                <td>".$estudio->preparacion."</td>
                <td>".$estudio->estatus."</td>
              </tr>
            ";

          }

          $code .= " 
                </tbody>
              </table>
            </div>
          ";

          echo $code;
        }

      }
      
      else {
        echo "Error: Campo Vacío";
      }

    }
    else {
      echo "Error: Solicitud invalida";
    }
  }
}
if($_POST){
  new EstudiosController($_POST);
}else{
  echo "Error POST";
}

